#' Methods for the co-ranking matrix
#' 
#' coRanking provides methods for the calculation of the co-ranking
#' matrix and derived measures to assess the quality of a
#' dimensionality reduction
#'
#' This package provides functions for calculating the co-ranking
#' matrix, plotitng functions and some derived measures for quality
#' assessment of dimensionality reductions.
#' 
#' Funding provided by the Department for Biogeochemical Integration,
#' Empirical Inference of the Earth System Group, at the Max Plack
#' Institute for Biogeochemistry, Jena.
#' 
#' @references
#' Lee, J.A., Lee, J.A., Verleysen, M., 2009. Quality assessment of
#'     dimensionality reduction: Rank-based criteria. Neurocomputing 72.
#'
#' Chen, L., Buja, A., 2006. Local Multidimensional
#'     Scaling for Nonlinear Dimension Reduction, Graph Layout and
#'     Proximity Analysis.
#'
#'
#' @docType package
"_PACKAGE"
