% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{CIF_res1}
\alias{CIF_res1}
\title{Compute Cumulative Incidence Function (CIF) Results}
\usage{
CIF_res1(initial_params = rep(0.001, 4))
}
\arguments{
\item{initial_params}{A numeric vector of initial parameter values to start the optimization. Default is \code{rep(0.001, 4)}.}
}
\value{
A data frame containing:
\item{Params}{The parameter names ("alpha1", "beta1", "alpha2", "beta2").}
\item{STD}{The standard deviations of the parameters.}
}
\description{
This function estimates the parameters of the model, computes the Hessian matrix, and calculates the variances and p-values for the parameters. It ensures that the diagonal elements of the covariance matrix are positive.
}
\details{
This function performs the following steps:
\itemize{
\item Estimates the model parameters using the \code{estimate_parameters} function.
\item Computes the Hessian matrix using the \code{compute_hessian} function.
\item Ensures that the diagonal elements of the covariance matrix are positive.
\item Calculates the variances and p-values for the parameters.
}
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
initial_params <- c(0.001, 0.001, 0.001, 0.001)
result <- CIF_res1(initial_params)
print(result)

}
