% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fadulData_processed}
\alias{fadulData_processed}
\alias{fadul1.1_processed}
\alias{fadul1.2_processed}
\title{Processed versions of the fadul1.1_raw and  fadul1.2_raw datasets using
preProcess_* functions from the cmcR package}
\format{
An x3p object containing a surface matrix and metainformation
concerning the conditions under which the scan was taken \describe{
\item{header.info}{size and resolution of scan}

\item{surface.matrix}{spatially-ordered matrix of elements representing the
height values of the processed cartridge case surface at particular
locations}

\item{feature.info}{provides structure for storing surface data}

\item{general.info}{information concerning the author of the scan and
capturing device}

\item{matrix.info}{provides link to surface measurements in binary format}

}

An object of class \code{x3p} of length 5.
}
\source{
\url{https://tsapps.nist.gov/NRBTD/Studies/CartridgeMeasurement/Details/2d9cc51f-6f66-40a0-973a-a9292dbee36d}
}
\usage{
fadul1.1_processed

fadul1.2_processed
}
\description{
"Fadul 1-1" and "Fadul 1-2" cartridge cases from Fadul et al. (2011). The
scans have been downsampled by a factor of 8 and processed using functions
from the cmcR package.
}
\seealso{
T. Fadul, G. Hernandez, S. Stoiloff, and G. Sneh. An Empirical Study
to Improve the Scientific Foundation of Forensic Firearm and Tool Mark
Identification Utilizing 10 Consecutively Manufactured Slides, 2011.

\url{https://github.com/heike/x3ptools}
}
\keyword{datasets}
