% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.clustcurv.R
\name{autoplot.clustcurv}
\alias{autoplot.clustcurv}
\title{Visualization of \code{clustcurv} objects with ggplot2 graphics}
\usage{
\method{autoplot}{clustcurv}(object = object, groups_by_colour = TRUE,
  centers = FALSE, conf.int = FALSE, censor = FALSE, xlab = "Time",
  ylab = "Survival", ...)
}
\arguments{
\item{object}{Object of \code{clustcurv} class.}

\item{groups_by_colour}{A specification for the plotting groups by color.}

\item{centers}{Draw the centroids (mean of the curves pertaining to the
same group) into the plot. By default it is \code{FALSE}.}

\item{conf.int}{Only for method = "survival". Logical flag indicating whether to plot confidence intervals.}

\item{censor}{Only for method = "survival". Logical flag indicating whether to plot censors.}

\item{xlab}{A title for the \code{x} axis.}

\item{ylab}{A title for the \code{y} axis.}

\item{\ldots}{Other options.}
}
\value{
A ggplot object, so you can use common features from
ggplot2 package to manipulate the plot.
}
\description{
Useful for drawing the estimated functions grouped by
color and the centroids (mean curve of the curves pertaining to the
same group).
}
\details{
See help page of the function \code{\link{autoplot.survfit}}.
}
\examples{

library(survival)
library(clustcurv)
library(condSURV)
library(ggplot2)
library(ggfortify)

# Survival

data(veteran)
data(colonCS)

cl2 <- kclustcurv(y = veteran$time, weights = veteran$status,
z = veteran$celltype, k = 2, method = "survival", algorithm = "kmeans")

autoplot(cl2)
autoplot(cl2, groups_by_colour = FALSE)
autoplot(cl2, centers = TRUE)

# Regression

r2 <- kclustcurv(y = barnacle5$DW, x = barnacle5$RC,
z = barnacle5$F, k = 2, method = "regression", algorithm = "kmeans")

autoplot(r2)
autoplot(r2, groups_by_colour = FALSE)
autoplot(r2, centers = TRUE)

\donttest{
colonCSm <- data.frame(time = colonCS$Stime, status = colonCS$event,
                      nodes = colonCS$nodes)

table(colonCSm$nodes)
colonCSm$nodes[colonCSm$nodes == 0] <- NA
colonCSm <- na.omit(colonCSm)
colonCSm$nodes[colonCSm$nodes >= 10] <- 10
table(colonCSm$nodes) # ten levels

res <- autoclustcurv(y = colonCSm$time, weights = colonCSm$status,
       z = colonCSm$nodes, method = "survival", algorithm = "kmeans",
       nboot = 20)

autoplot(res)
autoplot(res, groups_by_colour = FALSE)
autoplot(res, centers = TRUE)
}
}
\author{
Nora M. Villanueva and Marta Sestelo.
}
