% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{density_plot}
\alias{density_plot}
\title{density_plot}
\usage{
density_plot(cluster_results, var_selection = NULL, colourys = NULL)
}
\arguments{
\item{cluster_results}{Cluster results from function get_clusters}

\item{var_selection}{Selected variables to consider, e.g. c(1:5) for first five only}

\item{colourys}{A vector specifying the colors of each cluster (optional)}
}
\value{
A density plot of class recordedplot.
}
\description{
Create 2d dimensionality reduction of sample fit to Bayesian network clusters
}
\examples{
\donttest{
# Simulate data
sampled_data <- sampleData(n_vars = 15, n_samples = c(200,200,200))$sampled_data
# Learn clusters
cluster_results <- get_clusters(sampled_data)
# Load additional pacakges to create a 2d dimensionality reduction
library(car)
library(ks)
library(ggplot2)
library(graphics)
library(stats)
# Plot a 2d dimensionality reduction
density_plot(cluster_results)
}
}
