% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrected_mutual_information.R
\name{count_contingency_tables_log}
\alias{count_contingency_tables_log}
\title{Natural logarithm of the number of contingency tables}
\usage{
count_contingency_tables_log(c1, c2, M = NULL, monte_carlo_only = FALSE)
}
\arguments{
\item{c1, c2}{membership vectors}

\item{M}{contingency table}

\item{monte_carlo_only}{Uses only the Monte Carlo approximation}
}
\description{
Given a contingency table, returns the natural logarithm of the number of
contingency tables that share the same column and row sums. This implementation
combines a Markov Chain Monte Carlo approximation with an analytical formula.
The input can be either M a contingency table, or two vectors of labels c1 and c2 
(in this case, we are counting contingency tables with the same column an row sums as
the one produced by c1 and c2)
}
