% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signedrank.R
\name{cluswilcox.test.signedrank}
\alias{cluswilcox.test.signedrank}
\title{The Wilcoxon Signed Rank Test for Clustered Data}
\usage{
\method{cluswilcox.test}{signedrank}(x, cluster, alternative = c("two.sided",
  "less", "greater"), mu, DNAME = NULL, METHOD = NULL, ...)
}
\arguments{
\item{x}{numeric vector of data values. Non-finite (e.g.,
infinite or missing) values will be omitted.}

\item{cluster}{numeric or charater vector, the id of clusters.
 If not specified, each observation will
be assigned a distinct cluster, i.e., no cluster in the data.}

\item{alternative}{a character string specifying the
alternative hypothesis, must be one of "two.sided" (default),
 "greater" or "less". You can specify just the initial letter.}

\item{mu}{null value of the hypothesis}

\item{DNAME}{a character string, inheritated from
\code{cluswilcox.test.numeric}, for result output.}

\item{METHOD}{a character string, inheritated from
\code{cluswilcox.test.numeric}, for result output.}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
a list with class "\code{ctest}" containing
the following components:
\item{rstatistic}{the value of the signed rank statistic
 with a name describing it.}
\item{vrstatistic}{Variance of \code{rstatistic}.}
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{n}{Total number of observations.}
\item{cn}{Total number of clusters.}
\item{data.name}{a character string giving the names of the data.}
\item{method}{the type of test applied.}
\item{adjusted}{indicator of whether adjusted signed rank statistic is used.}
 @note This function is able to deal with data with
clusterentitical or variable cluster size. When the data
is unbalanced, adjusted signed rank statistic is used.
Ties are dropped in the test.
}
\description{
Performs one-sample Wilcoxon test on vectors of data using
large sample.
}
\examples{
data(crsd)
cluswilcox.test(z, cluster = id, data = crsd)
data(crsdUnb)
cluswilcox.test(z, cluster = id, data = crsdUnb)
}
\author{
Yujing Jiang
}
\references{
Bernard Rosner, Robert J. Glynn, Mei-Ling Ting Lee(2006)
\emph{The Wilcoxon Signed Rank Test for Paired Comparisons of
 Clustered Data.} Biometrics, \bold{62}, 185-192.
}

