## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(clubpro)

## ----set_palette--------------------------------------------------------------
palette(c("#0073C2", "#EFC000", "#868686"))

## ----model_jellyfish----------------------------------------------------------
mod <- club(width ~ location, data = jellyfish)

## ----pcc_jellyfish------------------------------------------------------------
pcc(mod)

## ----cval_jellyfish-----------------------------------------------------------
cval(mod)

## ----summary_jelyfish---------------------------------------------------------
summary(mod)

## ----plot_jellyfish-----------------------------------------------------------
plot(mod)

## ----plot_csi, fig.width=6, fig.height=8--------------------------------------
mod_csi <- csi(mod)
plot(mod_csi)

## ----predict_jellyfish--------------------------------------------------------
predict(mod)

## ----plot_predictions---------------------------------------------------------
plot(predict(mod))

## ----accuracy_jellyfish-------------------------------------------------------
accuracy(mod)

## ----plot_accuracy------------------------------------------------------------
plot(accuracy(mod))

## ----plot_cval_dist-----------------------------------------------------------
plot(pcc_replicates(mod))

