% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rma-mv.R
\name{impute_covariance_matrix}
\alias{impute_covariance_matrix}
\title{Impute a block-diagonal covariance matrix}
\usage{
impute_covariance_matrix(
  vi,
  cluster,
  r,
  ti,
  ar1,
  smooth_vi = FALSE,
  subgroup = NULL,
  return_list = identical(as.factor(cluster), sort(as.factor(cluster))),
  check_PD = TRUE
)
}
\arguments{
\item{vi}{Vector of variances}

\item{cluster}{Vector indicating which effects belong to the same cluster.
Effects with the same value of `cluster` will be treated as correlated.}

\item{r}{Vector or numeric value of assumed constant correlation(s) between
effect size estimates from each study.}

\item{ti}{Vector of time-points describing temporal spacing of effects, for
use with auto-regressive correlation structures.}

\item{ar1}{Vector or numeric value of assumed AR(1) auto-correlation(s)
between effect size estimates from each study. If specified, then \code{ti}
argument must be specified.}

\item{smooth_vi}{Logical indicating whether to smooth the marginal variances
by taking the average \code{vi} within each cluster. Defaults to
\code{FALSE}.}

\item{subgroup}{Vector of category labels describing sub-groups of effects.
If non-null, effects that share the same category label and the same
cluster will be treated as correlated, but effects with different category
labels will be treated as uncorrelated, even if they come from the same
cluster.}

\item{return_list}{Optional logical indicating whether to return a list of
matrices (with one entry per block) or the full variance-covariance matrix.}

\item{check_PD}{Optional logical indicating whether to check whether each
covariance matrix is positive definite. If \code{TRUE} (the default), the
function will display a warning if any covariance matrix is not positive
definite.}
}
\value{
If \code{cluster} is appropriately sorted, then a list of matrices,
  with one entry per cluster, will be returned by default. If \code{cluster}
  is out of order, then the full variance-covariace matrix will be returned
  by default. The output structure can be controlled with the optional
  \code{return_list} argument.
}
\description{
\loadmathjax{} \code{impute_covariance_matrix} calculates a
  block-diagonal covariance matrix, given the marginal variances, the block
  structure, and an assumed correlation structure. Can be used to create
  compound-symmetric structures, AR(1) auto-correlated structures, or
  combinations thereof.
}
\details{
A block-diagonal variance-covariance matrix (possibly represented as
  a list of matrices) with a specified structure. The structure depends on
  whether the \code{r} argument, \code{ar1} argument, or both arguments are
  specified. Let \mjeqn{v_{ij}}{v-ij} denote the specified variance for
  effect \mjeqn{i}{i} in cluster \mjeqn{j}{j} and \mjeqn{C_{hij}}{C-hij} be
  the covariance between effects \mjeqn{h}{h} and \mjeqn{i}{i} in cluster
  \mjeqn{j}{j}. \itemize{ \item{If only \code{r} is specified,}{ each block
  of the variance-covariance matrix will have a constant (compound symmetric)
  correlation, so that \mjdeqn{C_{hij} = r_j \sqrt{v_{hj} v_{ij},}}{C-hij =
  r-j * sqrt(v-hj v-ij),} where \mjeqn{r_j}{r-j} is the specified correlation
  for cluster \mjeqn{j}{j}. If only a single value is given in \code{r}, then
  it will be used for every cluster.} \item{If only \code{ar1} is
  specified,}{ each block of the variance-covariance matrix will have an
  AR(1) auto-correlation structure, so that \mjdeqn{C_{hij} = \phi_j^{|t_{hj}
  - t_{ij}|} \sqrt{v_{hj} v_{ij},}}{C-hij = (ar1-j)^|t-hj - t-ij| * sqrt(v-hj
  v-ij),} where \mjeqn{\phi_j}{ar1-j} is the specified auto-correlation
  for cluster \mjeqn{j}{j} and \mjeqn{t_{hj}}{t-hj} and \mjeqn{t_{ij}}{t-ij}
  are specified time-points corresponding to effects \mjeqn{h}{h} and
  \mjeqn{i}{i} in cluster \mjeqn{j}{j}. If only a single value is given in
  \code{ar1}, then it will be used for every cluster.} \item{If both \code{r}
  and \code{ar1} are specified,}{ each block of the variance-covariance
  matrix will have combination of compound symmetric and an AR(1)
  auto-correlation structures, so that \mjdeqn{C_{hij} = \left[r_j + (1 -
  r_j)\phi_j^{|t_{hj} - t_{ij}|}\right] \sqrt{v_{hj} v_{ij},}}{C-hij = [r-j +
  (1 - r-j)(ar1-j)^|t-hj - t-ij|] * sqrt(v-hj v-ij),} where
  \mjeqn{r_j}{r-j} is the specified constant correlation for cluster
  \mjeqn{j}{j}, \mjeqn{\phi_j}{ar1-j} is the specified auto-correlation for
  cluster \mjeqn{j}{j} and \mjeqn{t_{hj}}{t-hj} and \mjeqn{t_{ij}}{t-ij} are
  specified time-points corresponding to effects \mjeqn{h}{h} and
  \mjeqn{i}{i} in cluster \mjeqn{j}{j}. If only single values are given in
  \code{r} or \code{ar1}, they will be used for every cluster.} } If
  \code{smooth_vi = TRUE}, then all of the variances within cluster
  \mjeqn{j}{j} will be set equal to the average variance of cluster
  \mjeqn{j}{j}, i.e., \mjdeqn{v'_{ij} = \frac{1}{n_j} \sum_{i=1}^{n_j}
  v_{ij}}{v-ij' = (v-1j + ... + v-nj,j) / n-j} for
  \mjeqn{i=1,...,n_j}{i=1,...,n-j} and \mjeqn{j=1,...,k}{j=1,...,k}.
}
\examples{
library(metafor)

# Constant correlation
data(SATcoaching)
V_list <- impute_covariance_matrix(vi = SATcoaching$V, cluster = SATcoaching$study, r = 0.66)
MVFE <- rma.mv(d ~ 0 + test, V = V_list, data = SATcoaching)
conf_int(MVFE, vcov = "CR2", cluster = SATcoaching$study)

}
