/*
 * Decompiled with CFR 0.152.
 */
package ppe.ompi;

import com.amazonaws.services.ec2.model.InstanceType;
import java.io.File;
import ppe.ImproperParamException;
import ppe.InaccessibleFileException;
import ppe.ParamHt;
import ppe.ParamMissingException;
import ppe.ec2.ParamsEc2;

public class ParamsOmpi {
    public String networkName;
    public File rsaKeyPairFile;
    public int slotsPerHost;
    public boolean disableHyperthreading;
    public InstanceType instanceType;
    ParamHt ht;

    public ParamsOmpi(ParamHt ht, ParamsEc2 paramsEc2) throws InaccessibleFileException, ImproperParamException, ParamMissingException {
        this.ht = ht;
        this.setParamVals();
        this.networkName = paramsEc2.networkName;
        this.disableHyperthreading = paramsEc2.disableHyperthreading;
        this.instanceType = paramsEc2.instanceType;
        this.checkForAccessInstanceParams();
    }

    public void setParamVals() throws InaccessibleFileException, ImproperParamException {
        for (String key : this.ht.keySet()) {
            String val = (String)this.ht.get(key);
            this.setParamVal(key, val);
        }
    }

    public void setParamVal(String key, String val) throws InaccessibleFileException, ImproperParamException {
        String value = val.trim();
        ParamName nm = ParamName.valueForKey(key);
        if (nm == null) {
            return;
        }
        switch (nm) {
            case rsaKeyPairFile: {
                this.rsaKeyPairFile = new File(value);
                this.checkForReadFileAccess(this.rsaKeyPairFile);
                break;
            }
            case slotsPerHost: {
                this.slotsPerHost = Integer.parseInt(value);
                break;
            }
        }
    }

    private void checkForReadFileAccess(File f) throws InaccessibleFileException {
        if (f.exists() && !f.isDirectory() && f.canRead()) {
            return;
        }
        throw new InaccessibleFileException("RSA key pair file " + f.getPath() + " is not accessible: exists=" + f.exists() + "  is file=" + !f.isDirectory() + "  can read=" + f.canRead());
    }

    public void checkForAccessInstanceParams() throws ParamMissingException {
        String cfs = this.getConfigFileSuffix();
        String s = "";
        if (this.rsaKeyPairFile == null) {
            if (s.length() > 0) {
                s = s + "rsaKeyPairFile ";
            }
            s = s + "The required param rsaKeyPairFile was not specified in argv " + cfs;
            throw new ParamMissingException(s);
        }
    }

    private String getConfigFileSuffix() {
        String configFile = this.ht.getValue(ParamHt.ParamName.configFile.toString());
        String cfs = configFile != null ? "or in config file " + configFile : "and the default config file " + ParamHt.getDefaultConfigFilePath() + " does not exist.";
        return cfs;
    }

    public static enum ParamName {
        networkName,
        rsaKeyPairFile,
        slotsPerHost,
        disableHyperthreading,
        instanceType;

        String key = this.toString().toLowerCase();

        static ParamName valueForKey(String key) {
            for (ParamName pn : ParamName.values()) {
                if (!pn.key.equals(key)) continue;
                return pn;
            }
            return null;
        }
    }
}

