/*
 * Decompiled with CFR 0.152.
 */
package ppe;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nbl.utilj.SysProp;

public class UtilPPE {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> readConfigTypeFile(File f, String fieldDelimiterExpr, String commentMarker, int nFields) throws FileNotFoundException, IOException {
        FileReader r = null;
        BufferedReader b = null;
        try {
            String line;
            r = new FileReader(f);
            b = new BufferedReader(r);
            ArrayList<String[]> lines = new ArrayList<String[]>();
            while ((line = b.readLine()) != null) {
                String ln = line.trim();
                if (ln.startsWith(commentMarker) || ln.length() < 2 * nFields - 1) continue;
                if (nFields > 0) {
                    lines.add(ln.split(fieldDelimiterExpr, nFields));
                    continue;
                }
                lines.add(ln.split(fieldDelimiterExpr));
            }
            ArrayList<String[]> arrayList = lines;
            return arrayList;
        }
        finally {
            try {
                if (b != null) {
                    b.close();
                }
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iox) {
                throw new RuntimeException(iox);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfigFile(File f, List<String[]> lines, String delim) throws IOException {
        FileWriter w = null;
        BufferedWriter b = null;
        try {
            w = new FileWriter(f);
            b = new BufferedWriter(w);
            for (String[] line : lines) {
                for (int i = 0; i < line.length - 1; ++i) {
                    b.write(line[i] + delim);
                }
                b.write(line[line.length - 1] + "\n");
            }
        }
        finally {
            if (b != null) {
                b.flush();
                b.close();
            }
            if (w != null) {
                w.close();
            }
        }
    }

    public static List<String[]> readConfigTypeFile(File f, String fieldDelimiterExpr, String commentMarker) throws FileNotFoundException, IOException {
        return UtilPPE.readConfigTypeFile(f, fieldDelimiterExpr, commentMarker, -1);
    }

    public static boolean isValidBooleanFlag(String value) {
        String lv = value.toLowerCase();
        return lv.equals("true") || lv.equals("false");
    }

    public static File getTmpDir(String tmpDirName) {
        File tmpDir = new File(SysProp.user_home.getVal(), tmpDirName);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new RuntimeException(tmpDir.getPath() + " does not exist and " + " an attempt to create it failed.");
        }
        if (!tmpDir.canWrite()) {
            throw new RuntimeException(tmpDir.getPath() + " is not write accessible.");
        }
        return tmpDir;
    }

    public static int toYMD(long tm) {
        return Integer.parseInt(new SimpleDateFormat("yyyyMMdd").format(new Date(tm)));
    }

    public static long toYMDHMSM(long tm) {
        return Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(tm)));
    }

    public static String toDateTimeString(long tm) {
        return new SimpleDateFormat("yyyy MM dd HH mm ss").format(new Date(tm));
    }

    public static String f2(double x) {
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(2);
        f.setMinimumFractionDigits(2);
        return f.format(x);
    }

    public static String toCsv(List<String> strs) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strs.size() - 1; ++i) {
            s.append(strs + ", ");
        }
        s.append(strs.get(strs.size() - 1));
        return s.toString();
    }

    public static File getBackupFilename(File f) {
        File bu = null;
        int cnt = 0;
        do {
            String parent = f.getParent();
            String fname = f.getName();
            int idx = fname.lastIndexOf(".");
            String name = null;
            String ext = null;
            if (idx > 0) {
                name = fname.substring(0, idx);
                ext = fname.substring(idx);
            } else {
                name = fname;
                ext = "";
            }
            bu = new File(parent, name + "_" + UtilPPE.toYMD(System.currentTimeMillis()) + "_" + Integer.toString(cnt) + ext);
            ++cnt;
        } while (bu.exists());
        return bu;
    }

    public static boolean containsWhiteSpace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

