% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline_table.r
\name{baseline_table}
\alias{baseline_table}
\title{Create a baseline table for a dataset.}
\usage{
baseline_table(
  data,
  var_types = NULL,
  strata = NULL,
  vars = NULL,
  factor_vars = NULL,
  exact_vars = NULL,
  nonnormal_vars = NULL,
  seed = NULL,
  omit_missing_strata = FALSE,
  save_table = FALSE,
  filename = NULL,
  multiple_comparison_test = TRUE,
  p_adjust_method = "BH",
  smd = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{var_types}{An object from class \code{var_types} returned by \code{get_var_types} function.}

\item{strata}{A variable to stratify the table. Overwrites the strata variable in \code{var_types}.}

\item{vars}{A vector of variables to include in the table.}

\item{factor_vars}{A vector of factor variables. Overwrites the factor variables in \code{var_types}.}

\item{exact_vars}{A vector of variables to test for exactness. Overwrites the exact variables in \code{var_types}.}

\item{nonnormal_vars}{A vector of variables to test for normality. Overwrites the nonnormal variables in \code{var_types}.}

\item{seed}{A seed for the random number generator. This seed can be set for consistent simulation when
performing fisher exact tests.}

\item{omit_missing_strata}{A logical value indicating whether to omit missing values in the strata variable.}

\item{save_table}{A logical value indicating whether to save the result tables.}

\item{filename}{The name of the file to save the table. The file names for accompanying tables will
be the same as the main table, but with "_missing" and "_pairwise" appended.}

\item{multiple_comparison_test}{A logical value indicating whether to perform multiple comparison tests. Variables in
\code{factor_vars} and \code{exact_vars} are tested with pairwise \code{chisq.test} or \code{fisher.test}, and other variables are
tested with \code{rstatix::dunn_test} or \code{rstatix::games_howell_test}.}

\item{p_adjust_method}{The method to use for p-value adjustment for pairwise comparison. Default is "BH".
See \code{?p.adjust.methods}.}

\item{smd}{A logical value indicating whether to include SMD in the table. Passed to \code{tableone::print.TableOne}.}

\item{...}{Additional arguments passed to \code{tableone::print.TableOne}.}
}
\value{
A list containing the baseline table and accompanying tables.
}
\description{
Create a baseline table and a table of missing values. If the strata variable has more
than 2 levels, a pairwise comparison table will also be created.
}
\examples{
withr::with_tempdir(
  {
    data(cancer, package = "survival")
    var_types <- get_var_types(cancer, strata = "sex")
    baseline_table(cancer, var_types = var_types, filename = "baseline.csv")

    # baseline table with pairwise comparison
    cancer$ph.ecog_cat <- factor(cancer$ph.ecog,
      levels = c(0:3),
      labels = c("0", "1", ">=2", ">=2")
    )
    var_types <- get_var_types(cancer, strata = "ph.ecog_cat")
    baseline_table(cancer, var_types = var_types, filename = "baselineV2.csv")
    print(paste0("files saved to: ", getwd()))
  },
  clean = FALSE
)
}
