% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_extract.R
\name{ce_extract}
\alias{ce_extract}
\title{ce_extract}
\usage{
ce_extract(
  path = NULL,
  location = NULL,
  location_g = NULL,
  c_source = "WorldClim",
  var = "all"
)
}
\arguments{
\item{path}{Character. Path to folder containing the climate and elevation
raster data. The folders should be named prec, tmax, tavg and tmin and elev.
Within each climate folder there should be 12 raster files
(e.g. \code{"prec01.tif"}) corresponding to the monthly climate data. There should
be only one raster file within the elev subfolder named \code{"srtm.tif"}.}

\item{location}{A \code{"sp"}, \code{"sf"} polygon or point object. See
\link[sf:st]{sf::st_polygon} to make polygons and \link[sf:st_as_sf]{sf::st_as_sf} to make point
objects.}

\item{location_g}{Character. Informs how the zonal statistics are exported.
Must correspond to a column of the \code{"location"} argument. If NULL,
the zonal statistics are calculated for all features of \code{"location"} and a
warning issued.}

\item{c_source}{Character (e.g., \code{"CHELSA or WorldClim"}). Indicating the
climate data source.}

\item{var}{Character. If supplied will download a subset of the climate data.
Must be one of \code{"all"} (default), \code{"prec"}, \code{"tmax"}, \code{"tmin"} or \code{"tmean"}
to download the corresponding climate data.}
}
\value{
Returns a list storing matrices containing the mean and standard deviation
of the climate and/or elevation data. Each column represents a month, each
row represents a feature of the \code{location} \code{sp}, \code{sf} polygon
or point object. Values returned are either degrees Celsius for (tmax, tavg,
tmin) or mm (prec).
}
\description{
Extracts climate and/or elevation data for generated over an area or at fixed
point/s.
}
\examples{
# Create some random data

# Create temporary file
temp_path <- tempfile()
on.exit(unlink(file.path(temp_path)), add = TRUE)

# Create the required subdirectories
dir.create(file.path(temp_path, "/elev"), recursive = TRUE)
dir.create(file.path(temp_path, "/prec"), recursive = TRUE)
dir.create(file.path(temp_path, "/tmax"), recursive = TRUE)
dir.create(file.path(temp_path, "/tavg"), recursive = TRUE)
dir.create(file.path(temp_path, "/tmin"), recursive = TRUE)

# Create an empty raster
r <- terra::rast(ncol = 10, nrow = 10)

# Modify the base Raster
#* Elevation 100m ####
terra::values(r) <- 1:100
terra::writeRaster(r, paste0(temp_path, "/elev/srtm.tif"))

# create and save precipitation and temperature rasters ####
x <- c(5, 10, 15, 20, 25, 34, 25, 20, 15, 10, 5, 0) * 8
for (i in sprintf("\%02d", 1:12)) {
terra::writeRaster(r, paste0(temp_path, paste0("/prec/prec_", i, ".tif")))
terra::writeRaster(r, paste0(temp_path, paste0("/tmax/tmax_", i, ".tif")))
terra::writeRaster(r, paste0(temp_path, paste0("/tmin/tmin_", i, ".tif")))
terra::writeRaster(r, paste0(temp_path, paste0("/tavg/tavg_", i, ".tif")))
}

# Create a polygon file from the raster
terra::values(r) <- 1:100
pol_py <- sf::st_as_sf(terra::as.polygons(r))
pol_py$grp <- c(rep("low", 25), rep("high", 75))

# Run the download function
ce_extract(
  path = temp_path,
  location = pol_py,
  location_g = "grp"
)

}
\seealso{
The downloading (\code{\link[=ce_download]{ce_download()}}), and the plotting
(\code{\link[=plot_h]{plot_h()}} & \code{\link[=plot_wl]{plot_wl()}}) functions.
}
\author{
James L. Tsakalos and Martin R. Smith
}
