% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple-theme.R
\name{simple_theme}
\alias{simple_theme}
\title{A simple CLI theme}
\usage{
simple_theme(dark = getOption("cli.theme_dark", "auto"))
}
\arguments{
\item{dark}{Whether the theme should be optimized for a dark
background. If \code{"auto"}, then cli will try to detect this.
Detection usually works in recent RStudio versions, and in iTerm
on macOS, but not on other platforms.}
}
\description{
To use this theme, you can set it as the \code{cli.theme} option.
Note that this is in addition to the builtin theme, which is still in
effect.
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(cli.theme = cli::simple_theme())
}\if{html}{\out{</div>}}

and then CLI apps started after this will use it as the default theme.
You can also use it temporarily, in a div element:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_div(theme = cli::simple_theme())
}\if{html}{\out{</div>}}
}
\section{Showcase}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{show <- cli_div(theme = cli::simple_theme())

cli_h1("Heading 1")
cli_h2("Heading 2")
cli_h3("Heading 3")

cli_par()
cli_alert_danger("Danger alert")
cli_alert_warning("Warning alert")
cli_alert_info("Info alert")
cli_alert_success("Success alert")
cli_alert("Alert for starting a process or computation",
  class = "alert-start")
cli_end()

cli_text("Packages and versions: \{.pkg cli\} \{.version 1.0.0\}.")
cli_text("Time intervals: \{.timestamp 3.4s\}")

cli_text("\{.emph Emphasis\} and  \{.strong strong emphasis\}")

cli_text("This is a piece of code: \{.code sum(x) / length(x)\}")
cli_text("Function names: \{.fn cli::simple_theme\}")

cli_text("Files: \{.file /usr/bin/env\}")
cli_text("URLs: \{.url https://r-project.org\}")

cli_h2("Longer code chunk")
cli_par(class = "code R")
cli_verbatim(
  '# window functions are useful for grouped mutates',
  'mtcars \%>\%',
  '  group_by(cyl) \%>\%',
  '  mutate(rank = min_rank(desc(mpg)))')

cli_end(show)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> <span style="color: #2AA198;">──</span> <span style="font-weight: bold;color: #2AA198;">Heading 1</span> <span style="color: #2AA198;">─────────────────────────────────────────────────────────</span>          
#>                                                                                 
#> ─ <span style="font-weight: bold;color: #2AA198;">Heading 2</span> ──                                                                  
#>                                                                                 
#> <span style="color: #2AA198;">Heading 3</span>                                                                       
#> <span style="color: #EEE8D5;background-color: #DC322F;">✖ Danger alert</span>                                                                  
#> <span style="font-weight: bold;color: #ff9900;">! Warning alert</span>                                                                 
#> <span style="color: #2AA198;">ℹ</span> Info alert                                                                    
#> <span style="color: #859900;">✔</span> Success alert                                                                 
#> → Alert for starting a process or computation                                   
#>                                                                                 
#> Packages and versions: <span style="font-weight: bold;color: #268BD2;">cli</span> <span style="color: #268BD2;">1.0.0</span>.                                               
#> Time intervals: <span style="color: #b8b8b8;">[3.4s]</span>                                                          
#> <span style="font-style: italic;">Emphasis</span> and <span style="font-weight: bold;font-style: italic;">strong emphasis</span>                                                    
#> This is a piece of code: `sum(x) / length(x)`                                   
#> Function names: <span style="color: #292929;background-color: #f5f5f5;">`cli::simple_theme()`()</span>                                         
#> Files: <span style="color: #268BD2;">/usr/bin/env</span>                                                             
#> URLs: <span style="font-style: italic;color: #268BD2;">&lt;https://r-project.org&gt;</span>                                                   
#>                                                                                 
#> ─ <span style="font-weight: bold;color: #2AA198;">Longer code chunk</span> ──                                                          
#> <span style="font-style: italic;color: #a3a3a3;"># window functions are useful for grouped mutates</span>                               
#> mtcars <span style="color: #859900;">&#37;&gt;&#37;</span>                                                                      
#>   <span style="color: #2AA198;">group_by</span><span style="color: #B58900;">(</span>cyl<span style="color: #B58900;">)</span> <span style="color: #859900;">&#37;&gt;&#37;</span>                                                             
#>   <span style="color: #2AA198;">mutate</span><span style="color: #B58900;">(</span>rank = <span style="color: #2AA198;">min_rank</span><span style="color: #268BD2;">(</span><span style="color: #2AA198;">desc(</span>mpg<span style="color: #2AA198;">)</span><span style="color: #268BD2;">)</span><span style="color: #B58900;">)</span>                                            
#>                                                                                 
</pre></div>
}}
}

\seealso{
\link{themes}, \code{\link[=builtin_theme]{builtin_theme()}}.
}
