% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_alert}
\alias{cli_alert}
\alias{cli_alert_success}
\alias{cli_alert_danger}
\alias{cli_alert_warning}
\alias{cli_alert_info}
\title{CLI alerts}
\usage{
cli_alert(text, id = NULL, class = NULL, wrap = FALSE, .envir = parent.frame())

cli_alert_success(
  text,
  id = NULL,
  class = NULL,
  wrap = FALSE,
  .envir = parent.frame()
)

cli_alert_danger(
  text,
  id = NULL,
  class = NULL,
  wrap = FALSE,
  .envir = parent.frame()
)

cli_alert_warning(
  text,
  id = NULL,
  class = NULL,
  wrap = FALSE,
  .envir = parent.frame()
)

cli_alert_info(
  text,
  id = NULL,
  class = NULL,
  wrap = FALSE,
  .envir = parent.frame()
)
}
\arguments{
\item{text}{Text of the alert.}

\item{id}{Id of the alert element. Can be used in themes.}

\item{class}{Class of the alert element. Can be used in themes.}

\item{wrap}{Whether to auto-wrap the text of the alert.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
Alerts are typically short status messages.
}
\details{
\subsection{Success}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nbld <- 11
tbld <- prettyunits::pretty_sec(5.6)
cli_alert_success("Built \{.emph \{nbld\}\} status report\{?s\} in \{tbld\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #859900;">✔</span> Built <span style="font-style: italic;">11</span> status reports in 5.6s.                                              
</pre></div>
}}

}

\subsection{Info}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfl <- "~/.cache/files/latest.cache"
cli_alert_info("Updating cache file \{.path \{cfl\}\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #2AA198;">ℹ</span> Updating cache file <span style="color: #268BD2;">~/.cache/files/latest.cache</span>.                              
</pre></div>
}}

}

\subsection{Warning}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfl <- "~/.cache/files/latest.cache"
cli_alert_warning("Failed to update cache file \{.path \{cfl\}\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #B58900;">!</span> Failed to update cache file <span style="color: #268BD2;">~/.cache/files/latest.cache</span>.                      
</pre></div>
}}

}

\subsection{Danger}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfl <- "~/.config/report.yaml"
cli_alert_danger("Cannot validate config file at \{.path \{cfl\}\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #DC322F;">✖</span> Cannot validate config file at <span style="color: #268BD2;">~/.config/report.yaml</span>.                         
</pre></div>
}}

}

\subsection{Text wrapping}{

Alerts are printed without wrapping, unless you set \code{wrap = TRUE}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_alert_info("Data columns: \{.val \{names(mtcars)\}\}.")
cli_alert_info("Data columns: \{.val \{names(mtcars)\}\}.", wrap = TRUE)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #2AA198;">ℹ</span> Data columns: <span style="color: #268BD2;">"mpg"</span>, <span style="color: #268BD2;">"cyl"</span>, <span style="color: #268BD2;">"disp"</span>, <span style="color: #268BD2;">"hp"</span>, <span style="color: #268BD2;">"drat"</span>, <span style="color: #268BD2;">"wt"</span>, <span style="color: #268BD2;">"qsec"</span>, <span style="color: #268BD2;">"vs"</span>, <span style="color: #268BD2;">"am"</span>, <span style="color: #268BD2;">"g</span>
#> <span style="color: #268BD2;">ear"</span>, and <span style="color: #268BD2;">"carb"</span>.                                                               
#> <span style="color: #2AA198;">ℹ</span> Data columns: <span style="color: #268BD2;">"mpg"</span>, <span style="color: #268BD2;">"cyl"</span>, <span style="color: #268BD2;">"disp"</span>, <span style="color: #268BD2;">"hp"</span>, <span style="color: #268BD2;">"drat"</span>, <span style="color: #268BD2;">"wt"</span>, <span style="color: #268BD2;">"qsec"</span>,               
#> <span style="color: #268BD2;">"vs"</span>, <span style="color: #268BD2;">"am"</span>, <span style="color: #268BD2;">"gear"</span>, and <span style="color: #268BD2;">"carb"</span>.                                                 
</pre></div>
}}

}
}
