% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlang.R
\name{cli_abort}
\alias{cli_abort}
\alias{cli_warn}
\alias{cli_inform}
\title{Signal an error, warning or message with a cli formatted
message}
\usage{
cli_abort(message, ..., .envir = parent.frame())

cli_warn(message, ..., .envir = parent.frame())

cli_inform(message, ..., .envir = parent.frame())
}
\arguments{
\item{message}{It is formatted via a call to \code{\link[=cli_bullets]{cli_bullets()}}.}

\item{...}{Passed to \code{\link[rlang:abort]{rlang::abort()}}, \code{\link[rlang:abort]{rlang::warn()}} or
\code{\link[rlang:abort]{rlang::inform()}}.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
These functions let you create error, warning or diagnostic
messages with cli formatting, including inline styling,
pluralization andglue substitutions.
}
\examples{
\dontrun{
n <- "boo"
cli_abort(c(
        "{.var n} must be a numeric vector",
  "x" = "You've supplied a {.cls {class(n)}} vector."
))

len <- 26
idx <- 100
cli_abort(c(
        "Must index an existing element:",
  "i" = "There {?is/are} {len} element{?s}.",
  "x" = "You've tried to subset element {idx}."
))
}
}
