% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_pairs.R
\name{fowlkes_mallows_pairs}
\alias{fowlkes_mallows_pairs}
\title{Fowlkes-Mallows Index of Linked Pairs}
\usage{
fowlkes_mallows_pairs(true_pairs, pred_pairs, ordered = FALSE)
}
\arguments{
\item{true_pairs}{set of true coreferent pairs stored in a matrix or
data.frame, where rows index pairs and columns index the ids of the
constituents. Any pairs not included are assumed to be \emph{non-coreferent}.
Duplicate pairs (including equivalent pairs with reversed ids) are
automatically removed.}

\item{pred_pairs}{set of predicted coreferent pairs, following the same
specification as \code{true_pairs}.}

\item{ordered}{whether to treat the element pairs as ordered---i.e. whether
pair \eqn{(x, y)} is distinct from pair \eqn{(y, x)} for \eqn{x \neq y}.
Defaults to FALSE, which is appropriate for clustering, undirected link
prediction, record linkage etc.}
}
\description{
Computes the Fowlkes-Mallows index for a set of \emph{predicted}
coreferent (linked) pairs given a set of \emph{ground truth} coreferent pairs.
}
\details{
The Fowlkes-Mallows index is defined as the geometric mean of
precision \eqn{P} and recall \eqn{R}:
\deqn{\sqrt{P R}.}{√(P·R).}
}
\examples{
true_pairs <- rbind(c(1,2), c(2,3), c(1,3)) # ground truth is 3-clique
pred_pairs <- rbind(c(1,2), c(2,3))         # prediction misses one edge
num_pairs <- 3                              # assuming 3 elements
fowlkes_mallows_pairs(true_pairs, pred_pairs, num_pairs)

}
\references{
Fowlkes, E. B. and Mallows, C. L. "A Method for Comparing Two Hierarchical
Clusterings." \emph{Journal of the American Statistical Association} \strong{78:383},
553-569, (1983). DOI: \href{https://doi.org/10.1080/01621459.1983.10478008}{10.1080/01621459.1983.10478008}.
}
