\name{Clere-class}

\docType{class}

\alias{Clere-class}
\alias{[,Clere-method}
\alias{[<-,Clere-method}
\alias{show,Clere-method}

\alias{sClere-class}
\alias{show,sClere-method}
\alias{[,sClere-method}
\alias{[<-,sClere-method}

\title{
  \code{\linkS4class{Clere}} class
}

\description{
  This class contains all the input parameters to run CLERE.
}

% \section{Slots}{
\details{
  \describe{
    \item{y}{[numeric]: The vector of observed responses.}
    \item{x}{[matrix]: The matrix of predictors.}
    \item{n}{[integer]: The sample size or the number of rows in
      matrix x.}
    \item{p}{[integer]: The number of variables of the number of
      columns in matrix x.}
    \item{g}{[integer]: The number or the maximum number of groups considered. Maximum number of groups stands when model selection is required.}
    \item{nItMC}{[numeric]: Number of Gibbs iterations to generate the partitions.}
    \item{nItEM}{[numeric]: Number of SEM/MCEM   iterations.}
    \item{nBurn}{[numeric]: Number of SEM iterations  discarded before calculating the MLE which is averaged  over SEM draws.}
    \item{dp}{[numeric]: Number of iterations between sampled partitions when calculating the likelihood at the end of the run.}
    \item{nsamp}{[numeric]: Number of sampled partitions for calculating the likelihood at the end of the run.}
    \item{sparse}{[logical]: Should a \code{0} class be imposed to the model?}
    % \item{lambda}{[numeric]: }
    \item{analysis}{[character]: Which analysis is to be performed. Values are \code{"fit"}, \code{"bic"}, \code{"aic"} and \code{"icl"}.}
    \item{algorithm}{[character]: The algorithm to be chosen to fit
      the model. Either the SEM-Gibbs algorithm or the MCEM
      algorithm. The most efficient algorithm being the SEM-Gibbs
      approach. MCEM is not available for binary response.}	
    \item{initialized}{[logical]: Is set to TRUE when an initial
      partition and an initial vector of parameters is given by the user.}
    \item{maxit}{[numeric]: An EM algorithm is used inside the SEM
      to maximize the complete log-likelihood \code{p(y,Z|theta)}. \code{maxit} stands as the maximum number of EM
      iterations for the internal EM.}
    \item{tol}{[numeric]: Maximum increased in complete
      log-likelihood for the internal EM (stopping criterion).}
    \item{seed}{[integer]: An integer given as a seed for random
      number generation. If set to \code{NULL}, then a random seed
      is generated between \code{1} and \code{1000}.}
    \item{b}{[numeric]:  Vector of parameter b. Its size equals the number of group(s).}
    \item{pi}{[numeric]: Vector of parameter pi. Its size equals the number of group(s).}
    \item{sigma2}{[numeric]: Parameter sigma^2.}
    \item{gamma2}{[numeric]: Parameter gamma^2.}
    item{intercept}{[numeric]: Parameter beta_0 (intercept).}
    \item{likelihood}{[numeric]: Approximated log-likelihood.}
    \item{entropy}{[numeric]: Approximated entropy.}
    \item{P}{[matrix]: A  [\code{p x g}] matrix of posterior probability of membership
      to the groups. \code{P = E[Z|theta]}.}
    \item{theta}{[matrix]: A [\code{nItEM x (2g+4)}] matrix containing values
      of the model parameters and complete data likelihood at each
      iteration of the SEM/MCEM algorithm}
    \item{Bw}{[matrix]: A [\code{p x nsamp}] matrix which columns are samples
      from the posterior distribution of Beta (regression coefficients) given the data and the maximum likelihood estimates.}
    \item{Zw}{[matrix]: A [\code{p x nsamp}] matrix which columns are	samples from the posterior distribution of Z (groups membership indicators)
      given the data and the maximum likelihood estimates.}
    \item{theta0}{[numeric]: A vector size [\code{2g+3}] containing initial guess of the model parameters. See example for function \code{\link{fitClere}.}}
    \item{Z0}{[numeric]: A [\code{p x 1}] vector of integers taking values between 1 and \code{p} (number of variables).}
    % \item{message}{[character]: }
  }
}
\section{Methods}{
  \describe{
    \item{object["slotName"]:}{Get the value of the field \code{slotName}.}
    \item{object["slotName"]<-value:}{Set \code{value} to the field \code{slotName}.}
    \item{show(object):}{Returns the formatted values of \code{\linkS4class{Clere}} object.}
    \item{plot(x, ...):}{Graphical summary for MCEM/SEM-Gibbs estimation.}
    \item{clusters(object, threshold = NULL, ...):}{Returns the estimated clustering of variables.}
    \item{predict(object, newx, ...):}{Returns prediction using a fitted model and a new matrix of design.}
    \item{summary(object, ...):}{summarizes the output of function \code{\link{fitClere}}.}
  }
}

\seealso{
  Overview  : \code{\link{clere-package}} \cr
  Classes   : \code{\linkS4class{Clere}} \cr
  Methods   : \code{\link{show}}, \code{\link{plot}}, \code{\link{clusters}}, \code{\link{predict}}, \code{\link{summary}} \cr
  Functions : \code{\link{fitClere}}, \code{\link{fitPacs}}
  Datasets  : \code{\link{numExpRealData}}, \code{\link{numExpSimData}}
}
\author{Loic Yengo \email{loic.yengo@gmail.com}, Mickael Canouil \email{mickael.canouil@cnrs.fr}}

\keyword{Clere}
\keyword{class}
\keyword{methods}
\keyword{method}


