% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{cnlp_write_conll}
\alias{cnlp_write_conll}
\title{Returns a CoNLL-U Document}
\usage{
cnlp_write_conll(anno)
}
\arguments{
\item{anno}{annotation object to convert}
}
\value{
an annotation object with a single document
}
\description{
Given an annotation object, this function returns a CoNLL-U
document. The format of CoNLL-U is close to that of a deliminated
file, but includes blank lines to signal breaks between sentences.
We return a string object that can be saved to disk using the
function \code{readLines}. Note that CoNLL-U does not have a way
of distinguishing documents. Usually only one document is written
to a single file. If you want this behavior, see the examples.
Also note that this is a lossy procedure depending on the
annotations available, saving just tokenization, lemmatization,
part of speech tags, and dependencies.
}
\examples{
\dontrun{
for (i in cnlp_get_document(obama)$id) {
  anno <- extract_documents(obama, i)
  conll <- cnlp_write_conll(anno)
  writeLines(conll, sprintf("\%02d.conll", i))
}
}

}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
