% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{get_triple}
\alias{get_triple}
\title{Access triples from an annotation object}
\usage{
get_triple(annotation)
}
\arguments{
\item{annotation}{an annotation object}
}
\value{
Returns an object of class \code{c("tbl_df", "tbl", "data.frame")}
 containing one row for every triple found in the corpus.

 The returned data frame includes the following columns:

\itemize{
 \item{"id"}{ - integer. Id of the source document.}
 \item{"subject"}{ - character. Raw text of the triple's subject.}
 \item{"object"}{ - character. Raw text of the triple's object.}
 \item{"relation"}{ - character. Raw text of the triple's relation.}
 \item{"confidence"}{ - double. Confidence score from 0 (least confident) to 1 (most confident).}
 \item{"be_prefix"}{ - integer. Equals 1 if the triple's relationship has a form of "to be" as a prefix.}
 \item{"be_suffix"}{ - integer. Equals 1 if the triple's relationship has a form of "to be" as a suffix.}
 \item{"of_suffix"}{ - integer. Equals 1 if the triple's relationship has a form of "of" as a suffix.}
 \item{"tmod"}{ - integer. Equals 1 if the triple is a temporal modifier.}
 \item{"sid"}{ - integer. Sentence id of the triple.}
 \item{"tid_subject"}{ - integer. Token id at the start of the triple's subject.}
 \item{"tid_subject_end"}{ - integer. Token id at the end of the triple's subject.}
 \item{"tid_object"}{ - integer. Token id at the start of the triple's object.}
 \item{"tid_object_end"}{ - integer. Token id at the end of the triple's object.}
 \item{"tid_relation"}{ - integer. Token id at the start of the triple's relation.}
 \item{"tid_relation_end"}{ - integer. Token id at the end of the triple's relation.}
}
}
\description{
Relationship triples contain a subject, object, and relationship, all
extracted directly from the text. They represent factual statements whereby
the subject and object are related by the words consituting the relation.
}
\examples{

# what are the most common relations in the text?
get_triple(obama) \%>\%
  use_series(relation) \%>\%
  table() \%>\%
  sort(decreasing = TRUE) \%>\%
  head(n = 40L)

}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
\references{
Manning, Christopher D., Mihai Surdeanu, John Bauer, Jenny Finkel, Steven J. Bethard, and
  David McClosky. 2014. \href{http://nlp.stanford.edu/pubs/StanfordCoreNlp2014.pdf}{The Stanford CoreNLP Natural Language Processing Toolkit}.
  In: \emph{Proceedings of the 52nd Annual Meeting of the Association for Computational Linguistics: System Demonstrations, pp. 55-60.}

   Gabor Angeli, Melvin Johnson Premkumar, and Christopher D. Manning. Leveraging Linguistic Structure For Open Domain Information Extraction.
   In: \emph{Proceedings of the Association of Computational Linguistics (ACL), 2015}.
}

