% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.quality.report.R
\name{data.quality.report}
\alias{data.quality.report}
\title{Create the data quality report}
\usage{
data.quality.report(ccd, site = NULL, file = NULL, pdf = T,
  out = "report")
}
\arguments{
\item{ccd}{ccRecord}

\item{site}{a vector of the site ids for the site specified report.}

\item{file}{charcter a list of XML file origins.}

\item{pdf}{logical create the pdf version of the DQ report, 
otherwise stay in markdown format}

\item{out}{character output path}
}
\description{
Create a detailed data quality report, including file summary, site 
summary, data completeness, and density plot. The result can be found 
in {work_dir}/report/data_quality_report.{pdf}/{md}. Using this function, 
one can also create a site/trust specified report, see the argument "site". 
You need to make sure that you have the right to write into the {work_dir}.
}
\examples{
\dontrun{data.quality.report(ccd, c("Q70", "C90"))}
}

