\name{getPerm5Num}
\alias{getPerm5Num}
\title{
Get descriptive statistics from a permutation object 
}
\description{
The \code{getPerm5Num} function returns the "five number summary", a descriptive statistic that consists of the minimum, first (lower) quartile, median, third (upper) quartile and maximum value of a given distribution. In this case, the function is applied directly on the output of permutation testing, generated by the \code{\link{cfPermute}} function. 
}
\usage{
getPerm5Num(permObj)
}
\arguments{
  \item{permObj}{The permutation object as generated by \code{\link{cfPermute}}}
}
\value{
The \code{getPerm5Num} function returns an R object in the form of a list that contains the five number summary. The names of the returned statistics can be viewed by using the function \link{attributes}.
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]

permObj <- cfPermute(irisData, irisClass, bootNum = 10, ensNum = 20, permNum = 5, 
                     parallel = TRUE, cpus = 4, type = "SOCK")

getPerm5Num(permObj)
getPerm5Num(permObj)$median      
getPerm5Num(permObj)$minimum
getPerm5Num(permObj)$maximum
getPerm5Num(permObj)$upperQ
getPerm5Num(permObj)$lowerQ
}
}
\keyword{math}
