% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classicaltest.R
\name{classicaltest}
\alias{classicaltest}
\title{Classical test theory item and person statistics}
\usage{
classicaltest(
  x,
  key = NULL,
  categories = NULL,
  wt = NULL,
  listwise = FALSE,
  recScore = TRUE,
  administered = NULL
)
}
\arguments{
\item{x}{a data frame or matrix. For multiple choice items, columns can be
numeric or strings and keys should be provided. For polytomous items,
all columns should be numeric.}

\item{key}{a vector indicating the keys to score the data. If \code{NULL}
items are assumed as polytomous.
Default is \code{NULL}.}

\item{categories}{a vector indicating all possible categories.
If \code{NULL}, this vector will be created with all the non-NA
values present in \code{x}. Default is \code{NULL}.}

\item{wt}{a numeric vector of total weights. Default is \code{NULL}.}

\item{listwise}{only consider complete data (remove rows with NAs).
Defaulft is \code{FALSE}.}

\item{recScore}{a logical value indicating if the total score for
should be calculated based only on valid values. Thus,
if \code{TRUE}: \code{rowMeans(x,na.rm = TRUE)*apply(x,1L,function(k) sum(!is.na(k)))};
if \code{FALSE}: \code{rowMeans(x,na.rm = TRUE)*ncol(x)}. Defaulft is \code{TRUE}.
If \code{listwise}, this argument is meaningless.}

\item{administered}{a logical matrix indicating which items where administered.
The dimensions should be the same as \code{x}. If \code{NULL} all items
are considered administered.}
}
\value{
A list with item and person statistics.
}
\description{
Calculates several item and person statistics following
\code{ctitem()}, and \code{ctperson()}.
}
\examples{
data(dichodata)
data(polydata)
data(dichokey)

# Data preparation
## Random weights creation
set.seed(1919)
wt <- sample(x = 1:4, size = nrow(dichodata), replace = TRUE)

# Item and person analysis for multiple choice items
classicaltest(x = dichodata, key = dichokey, categories = c('A','B','C','D'), wt = wt)

# Item and person analysis for polytomous items
classicaltest(x = polydata, key = NULL, wt = wt)

}
