% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{workflows_put_git}
\alias{workflows_put_git}
\title{Attach an item to a file in a git repo}
\usage{
workflows_put_git(
  id,
  git_ref = NULL,
  git_branch = NULL,
  git_path = NULL,
  git_repo_url = NULL,
  pull_from_git = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the file.}

\item{git_ref}{string optional. A git reference specifying an unambiguous version of the file. Can be a branch name, or the full or shortened SHA of a commit.}

\item{git_branch}{string optional. The git branch that the file is on.}

\item{git_path}{string optional. The path of the file in the repository.}

\item{git_repo_url}{string optional. The URL of the git repository.}

\item{pull_from_git}{boolean optional. Automatically pull latest commit from git. Only works for scripts.}
}
\value{
A list containing the following elements:
\item{gitRef}{string, A git reference specifying an unambiguous version of the file. Can be a branch name, or the full or shortened SHA of a commit.}
\item{gitBranch}{string, The git branch that the file is on.}
\item{gitPath}{string, The path of the file in the repository.}
\item{gitRepo}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID for this git repository.
\item repoUrl string, The URL for this git repository.
\item createdAt string, 
\item updatedAt string, 
}}
\item{pullFromGit}{boolean, Automatically pull latest commit from git. Only works for scripts.}
}
\description{
Attach an item to a file in a git repo
}
