% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{services_list}
\alias{services_list}
\title{List Services}
\usage{
services_list(hidden = NULL, archived = NULL, author = NULL,
  status = NULL, limit = NULL, page_num = NULL, order = NULL,
  order_dir = NULL)
}
\arguments{
\item{hidden}{boolean optional. If specified to be true, returns hidden objects. Defaults to false, returning non-hidden objects.}

\item{archived}{string optional. The archival status of the requested object(s).}

\item{author}{string optional. If specified, return imports from this author. It accepts a comma-separated list of author IDs.}

\item{status}{string optional. If specified, returns Services with one of these statuses. It accepts a comma-separated list, possible values are 'running', 'idle'.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for this Service.}
\item{name}{string, The name of this Service.}
\item{description}{string, The description of this Service.}
\item{user}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{gitRepoUrl}{string, The url for the git repo where the Service code lives.}
\item{gitRepoRef}{string, The git reference to use when pulling code from the repo.}
\item{gitPathDir}{string, The path to the Shiny app code within the git repo. If unspecified, the root directory will be used.}
\item{currentDeployment}{object, A list containing the following elements: 
\itemize{
\item deploymentId integer, The ID for this deployment.
\item userId integer, The ID of the owner.
\item host string, Domain of the deployment.
\item name string, Name of the deployment.
\item dockerImageName string, The name of the docker image to pull from DockerHub.
\item dockerImageTag string, The tag of the docker image to pull from DockerHub (default: latest).
\item instanceType string, The EC2 instance type requested for the deployment.
\item memory integer, The memory allocated to the deployment.
\item cpu integer, The cpu allocated to the deployment.
\item state string, The state of the deployment.
\item stateMessage string, A detailed description of the state.
\item createdAt string, 
\item updatedAt string, 
\item published boolean, 
\item serviceId integer, The ID of owning Service
}}
\item{previewDeployment}{object, A list containing the following elements: 
\itemize{
\item deploymentId integer, The ID for this deployment.
\item userId integer, The ID of the owner.
\item host string, Domain of the deployment.
\item name string, Name of the deployment.
\item dockerImageName string, The name of the docker image to pull from DockerHub.
\item dockerImageTag string, The tag of the docker image to pull from DockerHub (default: latest).
\item instanceType string, The EC2 instance type requested for the deployment.
\item memory integer, The memory allocated to the deployment.
\item cpu integer, The cpu allocated to the deployment.
\item state string, The state of the deployment.
\item stateMessage string, A detailed description of the state.
\item createdAt string, 
\item updatedAt string, 
\item published boolean, 
\item serviceId integer, The ID of owning Service
}}
\item{archived}{string, The archival status of the requested object(s).}
}
\description{
List Services
}
