% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{files_get}
\alias{files_get}
\title{Get details about a file}
\usage{
files_get(id, link_expires_at = NULL)
}
\arguments{
\item{id}{integer required. The ID of the file object.}

\item{link_expires_at}{string optional. The date and time the download link will expire. Must be a time between now and 36 hours from now. Defaults to 30 minutes from now.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the file object.}
\item{name}{string, The file name.}
\item{createdAt}{string, The date and time the file was created.}
\item{fileSize}{integer, The file size.}
\item{expiresAt}{string, The date and time the file will expire. If not specified, the file will expire in 30 days. To keep a file indefinitely, specify null.}
\item{downloadUrl}{string, A JSON string containing information about the URL of the file.}
\item{fileUrl}{string, The URL that may be used to download the file.}
}
\description{
Get details about a file
}
