% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{FLXMRspcauchy}
\alias{FLXMRspcauchy}
\title{Spherical Cauchy Driver for FlexMix Using Neural Networks}
\usage{
FLXMRspcauchy(
  formula = . ~ .,
  EPOCHS = 100,
  LR = 0.1,
  max_iter = 200,
  adam_iter = 5,
  free_iter = adam_iter,
  line_search_fn = "strong_wolfe"
)
}
\arguments{
\item{formula}{A formula.}

\item{EPOCHS}{EPOCHS The number of epochs in the M-step estimation (default: 100).}

\item{LR}{The learning rate used in the M-steo estimation (default: 0.1).}

\item{max_iter}{The maximum number of iterations of the LBFGS optimizer (default: 200).}

\item{adam_iter}{The number of iteration for which the adam optimizer is used before the algorithm switches to L-BFGS (default: 5).}

\item{free_iter}{The number of initial iterations for which the model in M-step is fully reseted (default: adam_iter).}

\item{line_search_fn}{The method used for line search in LBFGS (default: "strong_wolfe").}
}
\value{
Returns an object of class \code{FLXMC}.
}
\description{
This model driver for flexmix implements model-based
clustering of spherical Cauchy distributions using neural
networks in the M-step.
}
\examples{
\donttest{
if(torch::torch_is_installed()){
mix <- rbind(rpkbd(30, 0.95, c(1, 0, 0)), rpkbd(30, 0.9, c(-1, 0, 0)))
m1 <- flexmix::flexmix(mix ~ 1, k = 2, model = FLXMRspcauchy())
}
}
}
