% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_xifti2.R
\name{read_xifti2}
\alias{read_xifti2}
\title{Read in GIFTI files as a \code{"xifti"} object}
\usage{
read_xifti2(
  cortexL = NULL,
  cortexL_mwall = NULL,
  cortexR = NULL,
  cortexR_mwall = NULL,
  mwall_values = c(NA, NaN),
  surfL = NULL,
  surfR = NULL,
  resamp_res = NULL,
  col_names = NULL,
  HCP_32k_auto_mwall = TRUE,
  read_dir = NULL,
  validate = TRUE
)
}
\arguments{
\item{cortexL, cortexL_mwall}{Left cortex data and ROI. Each must be a path to
a metric or label GIFTI file.

If \code{cortexL_mwall} is not provided, \code{cortexL} should have data for
all vertices on the left cortical surface (\eqn{V_L \times T} data matrix). There
will not be a mask for the medial wall. Not providing the medial wall mask
is appropriate for ".dlabels.nii" files where the medial wall may have its
own label and therefore should not be treated as missing data.

If \code{cortexL_mwall} is provided, \code{cortexL} should either have data
for all vertices on the left cortical surface (\eqn{V_L \times T} data matrix, with
filler values e.g. \code{0} or \code{NaN} for medial wall vertices), or have data
only for non-medial wall vertices (\eqn{(V_L - mwall_L) \times T} data matrix).
The medial wall mask will be the \code{0} values in \code{cortexL_mwall}.
The medial wall mask should be provided whenever the medial wall should be
treated as missing data.

Since the unmasked cortices must have the same number of vertices,
\code{V_L} should match \code{V_R}, or \code{resamp_res} must be set.}

\item{cortexR, cortexR_mwall}{Right cortex data and ROI. Each must be a path to
a metric or label GIFTI file.

If \code{cortexR_mwall} is not provided, \code{cortexR} should have data for
all vertices on the right cortical surface (\eqn{V_R \times T} data mre
will not be a mask for the medial wall. Not providing the medial wall mask
is appropriate for ".dlabels.nii" files where the medial wall may have its
own label and therefore should not be treated as missing data.

If \code{cortexR_mwall} is provided, \code{cortexR} should either have data
for all vertices on the right cortical surface (\eqn{V_R \times T} data matrix, with
filler values e.g. \code{0} or \code{NaN} for medial wall vertices), or have data
only for non-medial wall vertices (\eqn{(V_R - mwall_R) \times T} data matrix).
The medial wall mask will be the \code{0} values in \code{cortexR_mwall}.
The medial wall mask should be provided whenever the medial wall should be
treated as missing data.

Since the unmasked cortices must have the same number of vertices,
\code{V_L} should match \code{V_R}, or \code{resamp_res} must be set.}

\item{mwall_values}{If \code{cortex[L/R]_mwall} was not provided, or if it
was invalid (i.e. bad length or all \code{TRUE}), the medial wall mask will
be inferred from rows in \code{cortex[L/R]} that are constantly one of these
values. Default: \code{c(NA, NaN)}. If \code{NULL}, do not attempt to infer
the medial wall from the data values. \code{NULL} should be used if \code{NA}
or \code{NaN} are legitimate values that non-medial wall vertices might
take on.}

\item{surfL, surfR}{(Optional) File path(s) to surface GIFTI(s) for the left
or right cortex.}

\item{resamp_res}{Resolution to resample the cortical data and surface to.
Default: \code{NULL} (do not resample). If provided, the original resolutions
of the cortex data and surfaces may differ.}

\item{col_names}{Names of each measurement/column in the data. Overrides
names indicated in the data components.}

\item{HCP_32k_auto_mwall}{If left and/or right cortex data is provided, and
the number of vertices matches that of the HCP 32k mesh (29696 on left, and
29716 on right), should the medial wall masks be added to the \code{"xifti"}
if not provided? Default: \code{TRUE}.}

\item{read_dir}{(Optional) Append a directory to all file names in the
arguments. If \code{NULL} (default), do not modify file names.}

\item{validate}{Validate that the result is a \code{"xifti"} object? Default:
\code{TRUE}. If \code{FALSE}, the result may not be properly formatted
if the inputs were invalid.}
}
\value{
The \code{"xifti"} object containing all the data in the input giftis.
}
\description{
Read in GIFTI metric or label files as a \code{"xifti"} object. May also include
surface geometry GIFTI files and perform resampling.
}
\seealso{
Other reading: 
\code{\link{as.xifti}()},
\code{\link{info_cifti}()},
\code{\link{load_parc}()},
\code{\link{load_surf}()},
\code{\link{read_cifti}()},
\code{\link{read_surf}()}
}
\concept{reading}
