% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{parseRuletable}
\alias{parseRuletable}
\title{Obtain an internal representation of a CIfly ruletable.}
\usage{
parseRuletable(ruletable, tableAsString = FALSE)
}
\arguments{
\item{ruletable}{Path to a ruletable file.}

\item{tableAsString}{Optional argument to enable passing the ruletable as multi-line string. Default value is FALSE.}
}
\value{
Internal CIfly ruletable representation.
}
\description{
Obtain an internal representation of a CIfly ruletable. Advanced usage only, mostly recommended for improving performance if the same ruletable is used multiple times. The parsed ruletable object can be passed to all methods with a ruletable argument.
}
\examples{
dsepTable <- "
    EDGES --> <--
    SETS X, Z
    START <-- AT X
    OUTPUT ...
    --> | <-- | current in Z
    ... | ... | current not in Z
"

rt <- parseRuletable(dsepTable, tableAsString=TRUE)
edgelist <- list("-->" = rbind(c(1, 2), c(3, 2), c(2, 4)))
sets <- list("X" = c(1), "Z" = c(4))
reach(edgelist, sets, rt)
}
