% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{highlight}
\alias{highlight}
\alias{initialise}
\title{Highlight & Initialise}
\usage{
highlight(
  el,
  id,
  title = NULL,
  description = NULL,
  position = NULL,
  class = NULL,
  show_btns = NULL,
  close_btn_text = NULL,
  next_btn_text = NULL,
  prev_btn_text = NULL,
  session = NULL
)

initialise(
  id,
  animate = TRUE,
  opacity = 0.75,
  padding = 10,
  allow_close = TRUE,
  overlay_click_next = FALSE,
  done_btn_text = "Done",
  close_btn_text = "Close",
  stage_background = "#ffffff",
  next_btn_text = "Next",
  prev_btn_text = "Previous",
  show_btns = TRUE,
  keyboard_control = TRUE,
  session = NULL
)
}
\arguments{
\item{el}{Id of element to be highlighted.}

\item{id}{Unique identifier of cicerone.}

\item{title}{Title on the popover.}

\item{description}{Body of the popover.}

\item{position}{Where to position the popover.
See positions section.}

\item{class}{className to wrap this specific step
popover in addition to the general className in Driver
options.}

\item{show_btns}{Do not show control buttons in footer.}

\item{close_btn_text}{Text on the close button for this step.}

\item{next_btn_text}{Next button text for this step.}

\item{prev_btn_text}{Previous button text for this step.}

\item{session}{A valid Shiny session if \code{NULL}
the function attempts to get the session with
\code{\link[shiny:domains]{shiny::getDefaultReactiveDomain()}}.}

\item{animate}{Whether to animate or not.}

\item{opacity}{Background opacity (0 means only popovers
and without overlay).}

\item{padding}{Distance of element from around the edges.}

\item{allow_close}{Whether the click on overlay should close
or not.}

\item{overlay_click_next}{Whether the click on overlay should
move next.}

\item{done_btn_text}{Text on the final button.}

\item{stage_background}{Background color for the staged behind
highlighted element.}

\item{keyboard_control}{Allow controlling through keyboard (escape
to close, arrow keys to move).}
}
\description{
Initialise and highlight an element.
}
\section{Position}{

\itemize{
\item left
\item right
\item left-center
\item left-bottom
\item top
\item top-center
\item top-right
\item right
\item right-center
\item right-bottom
\item bottom
\item bottom-center
\item mid-center
}
}

