% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronochrt_convert_to_chron.R
\name{convert_to_chron}
\alias{convert_to_chron}
\title{Prepare an existing data set for plotting}
\usage{
convert_to_chron(data, region, name, start, end, level, add)
}
\arguments{
\item{data}{A data frame or tibble}

\item{region}{The column name of the regions/sections in the plot.}

\item{name}{The column name of the names of the chronological units. Must be
a character string.}

\item{start}{The column name of the start dates of the chronological units.}

\item{end}{The column name of the end date of the chronological units.}

\item{level}{The column name of the level of the chronological unit.}

\item{add}{The column name of the columns which signals whether the
chronological units within a geographical area should be drawn separately.}
}
\value{
A tibble with chronological data ready-to-use for plotting with
  \code{\link{plot_chronochrt}}.
}
\description{
Convert an existing data set in a ready-to-plot data set.
}
\details{
Additional columns if the data set are directly passed to the output.
}
\examples{
# Create example data set
data <- data.frame(Location = c("A", "B"),
                   Dynasty = c("a", "a"),
                   Begin = -100,
                   End = c(200, 150),
                   Subunit = 1,
                   Parallel = FALSE)

# Convert to chronological data set
chrons <- convert_to_chron(data = data,
                           region = Location,
                           name = Dynasty,
                           start = Begin,
                           end = End,
                           level = Subunit,
                           add = Parallel)
}
