% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dygraphs.R
\name{add_dygraph}
\alias{add_dygraph}
\title{Add a dygraph to a chronicle report}
\usage{
add_dygraph(
  report = "",
  dt,
  value,
  date,
  groups = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = NULL,
  dygraph_title = NULL,
  title_level = 2,
  echo = FALSE,
  message = FALSE,
  warning = FALSE,
  fig_width = NULL,
  fig_height = NULL
)
}
\arguments{
\item{report}{Character string containing the text of an Rmarkdown report header (and possibly more chunks). Easily create one with chronicle::new_report(), and if NULL, that will be the default value.}

\item{dt}{Data to plot}

\item{value}{Name of the column of the data frame containing the numerical variables of the time series.}

\item{date}{Name of the column containing the date variable. It must be already a date or time object.}

\item{groups}{Name of the columns containing the different groups.}

\item{y_axis_label}{Label for the y axis. x axis is the date (or time) so it is not needed}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{dygraph_title}{Title for the Rmarkdown section containing the dygraph}

\item{title_level}{Level of the section title of this plot (ie, number of # on Rmarkdown syntax.)}

\item{echo}{Whether to display the source code in the output document. Default is FALSE.}

\item{message}{Whether to preserve messages on rendering. Default is FALSE.}

\item{warning}{Whether to preserve warnings on rendering. Default is FALSE.}

\item{fig_width}{Width of the plot (in inches).}

\item{fig_height}{Height of the plot (in inches).}
}
\value{
An R Markdown file as a character string, now containing a chunk for the specified dygraph.
}
\description{
Add a dygraph to a chronicle report
}
\examples{
dat <- data.frame(x = c(rnorm(100, 2, 4),
                        rnorm(100, 6, 1),
                        rnorm(100, 8, 2)),
                 group = c(rep('A', 100),
                           rep('B', 100),
                           rep('C', 100)),
                 date = rep(seq(as.Date("2020-01-01"),
                                as.Date("2020-04-09"),
                                'days'),
                            3))
html_report <- add_dygraph(report = new_report(),
                          dt = dat,
                          value = 'x',
                          date = 'date')
cat(html_report)
}
