% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten_gcms.R
\name{flatten_gcms}
\alias{flatten_gcms}
\title{Flatten General Circulation Models (GCMs)}
\usage{
flatten_gcms(s)
}
\arguments{
\item{s}{A list of transformed \code{data.frame}s representing GCMs.}
}
\value{
A \code{data.frame} with columns as GCMs and rows as values from each cell to each variable.
}
\description{
Scale and flatten a list of GCMs \code{data.frame}s.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)
study_area <- terra::ext(c(-80, -30, -50, 10)) |> terra::vect(crs="epsg:4326")
s_trans <- transform_gcms(s, var_names, study_area)
flattened_gcms <- flatten_gcms(s_trans)

}
\seealso{
\code{\link{transform_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
