% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeSeries.R
\name{timeSeries}
\alias{timeSeries}
\title{Aggregate time series fatality data from the Vestry report.}
\usage{
timeSeries(vestry = FALSE)
}
\arguments{
\item{vestry}{Logical. TRUE returns the data from the Vestry committee (Appendix B, p. 175). FALSE (default) returns John Snow's contribution to the report (p.117).}
}
\value{
A R list with two objects: "data" and "source" ("snow" or "vestry").
\itemize{
  \item{\code{date}: Calendar date.}
  \item{\code{deaths}: measure of fatality.}
  \item{\code{fatal.attacks}: measure of fatality.}
}
}
\description{
For use in integrating pumps and cases into road network needed to compute walking neighborhoods.
}
\section{Note}{
 the "snow" data appears on p. 117 of the report; the "vestry" data appear in Appendix B on p.175.
}

