% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pumpLocator.R
\name{pumpLocator}
\alias{pumpLocator}
\title{Locate water pump by numerical ID.}
\usage{
pumpLocator(id, zoom = FALSE, radius = 2, vestry = FALSE)
}
\arguments{
\item{id}{Numeric or Integer. With "vestry = TRUE", a whole number between 1 and 14. With "vestry = FALSE", a whole number between 1 and 13. See cholera::pumps.vestry and cholera::pumps for IDs and details about specific pumps.}

\item{zoom}{Logical.}

\item{radius}{Numeric. Controls the degree of zoom.}

\item{vestry}{Logical. TRUE for the 14 pumps from Vestry Report. FALSE for the original 13 pumps.}
}
\value{
A base R graphics plot.
}
\description{
Plots John Snow's map of the 1854 London cholera outbreak and highlights the
selected water pump.
}
\examples{
pumpLocator(7) # Broad Street Pump
pumpLocator(7, zoom = TRUE)
pumpLocator(7, zoom = TRUE, radius = 1)
pumpLocator(14, vestry = TRUE, zoom = TRUE, radius = 1)
}
\seealso{
\code{\link{pumpData}}
}
