% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-string.R
\name{chk_string}
\alias{chk_string}
\alias{vld_string}
\title{Check String}
\usage{
chk_string(x, x_name = NULL)

vld_string(x, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if string

\code{is.character(x) && length(x) == 1L && !anyNA(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_string}: Validate String
}}

\examples{
# chk_string
chk_string("1")
try(chk_string(1))
# vld_string
vld_string("1")
vld_string("")
vld_string(1)
vld_string(NA_character_)
vld_string(c("1", "1"))
}
\seealso{
Other chk_scalars: 
\code{\link{chk_date_time}()},
\code{\link{chk_date}()},
\code{\link{chk_number}()},
\code{\link{chk_scalar}()},
\code{\link{chk_tz}()},
\code{\link{chk_whole_number}()}
}
\concept{chk_scalars}
