\name{chipPCR-package}
\alias{chipPCR-package}
\alias{chipPCR}
\docType{package}
\title{
Toolkit of helper functions to pre-process amplification data
}
\description{
The \code{chipPCR} package is a toolkit of helper functions to pre-process amplification data. 
Amplification data can be obtained from classical PCR reactions or isothermal amplification 
reactions. The package contains functions to normalize amplification, a simple routine to detect 
the start of an amplification reaction and several smoothers for amplification data. The smoothers 
are based on LOWESS, moving average, cubic splines, Savitzky-Golay and others. In addition 
the first approximate approximate derivative maximum (FDM) and second approximate derivative 
maximum (SDM) can be calculated as quantification points from real-time amplification curves. 
\code{chipPCR} contains data sets of experimental nucleic acid amplification systems including the 
VideoScan HCU and a capillary convective PCR (ccPCR) system. The amplification data were generated 
by helicase dependent amplification (HDA) or polymerase chain reaction (PCR) under various 
temperature conditions. As detection system intercalating dyes (EvaGreen, SYBR Green) and 
hydrolysis probes (TaqMan) were used.
}
\details{
\tabular{ll}{
Package: \tab chipPCR\cr
Type: \tab Package\cr
Version: \tab 0.0.5\cr
Date: \tab 2013-12-12\cr
License: \tab GPL-3\cr
}
The function \code{bg.max} can be used to remove missing values in amplification curve data. 
\code{amptester} is used to test if an amplification is positive. \code{fixNA} is used to impute 
missing values from a data column. \code{CPP} can be used to normalize curve data, to remove 
background, to remove outliers and further steps. The package includes further functions to smooth
the data by different functions including LOWESS, Moving Average, Friedman's SuperSmoother, Cubic 
Spline and Savitzky-Golay smoothing.
}
\author{
Stefan Roediger, Michal Burdukiewicz

Maintainer: Stefan Roediger <stefan.roediger@hs-lausitz.de>

}
\references{
A Highly Versatile Microscope Imaging Technology Platform for the Multiplex Real-Time Detection of 
Biomolecules and Autoimmune Antibodies. S. Roediger, P. Schierack, A. Boehm, J. Nitschke, I. Berger, 
U. Froemmel, C. Schmidt, M. Ruhland, I. Schimke, D. Roggenbuck, W. Lehmann and C. Schroeder.
\emph{Advances in Biochemical Bioengineering/Biotechnology}. 133:33--74, 2013.
\url{http://www.ncbi.nlm.nih.gov/pubmed/22437246}
}
\keyword{ chipPCR }
\seealso{
\link[qpcR]{qpcR.news}.
}
\examples{
# Example: A simple function to test for a background range.
# Data were taken form the chipPCR C17 data set.
data(C17)
plot(C17[, 2], C17[,  3], xlab = "time [min]", ylab = "Fluorescence", pch = 20)
res <- bg.max(C17[, 2], C17[, 3], bg.corr = 1.4, bg.start = 3, verbose = FALSE)
abline(v = c(res$bg.start, res$bg.stop), col = c(1,2))
abline(h = res$fluo, col = "blue")
}
