% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dir_or_file.R
\name{dir_or_file}
\alias{dir_or_file}
\title{Collect Full Filenames from a Mix of Directories and Files}
\usage{
dir_or_file(..., special = "")
}
\arguments{
\item{...}{names of directories and files; if the input is not vector, the function will try to 
coerce it. Relative paths and paths starting with "~/" are also accepted. 
In Windows, both "/"  and double inversed slashes inside filenames are accepted.}

\item{special}{a length 1 character or regular expression. Only filenames that have this pattern
will be collected. Default value is "" (character with size 0), and is to collect everything.}
}
\value{
a character vector of full filenames with increasing order, and every name is 
unique. If no filename is collected, an error will be raised.
}
\description{
The input can be one or more directories, one or more files, or the mixture of the two. 
It will return the full paths of all files in a recursive way, 
and sort them in increasing order. When files are put in 
different areas of your disk, you may need this function to collect them. 
It is essentially a wrapper of \code{\link{list.files}}.
}
\details{
Failure may occur when obtaining absolute paths, please see \code{\link{normalizePath}} 
for possible reasons.
}
\examples{
x1 <- find.package("base")
x2 <- find.package("utils")
all_file <- dir_or_file(x1, x2, special = "rds$")
}

