% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsfg.R
\name{nsfg}
\alias{nsfg}
\title{Read and recode National Survey of Family Growth (NSFG) data}
\usage{
nsfg(years, progress = TRUE)
}
\arguments{
\item{years}{vector: a numeric vector containing the starting year of NSFG waves to include (2002, 2006, 2011, 2013, 2015, 2017)}

\item{progress}{boolean: display a progress bar}
}
\value{
A data frame containing variables described in the codebook available using \code{vignette("codebooks")}
}
\description{
Read and recode National Survey of Family Growth (NSFG) data
}
\details{
The U.S. Centers for Disease Control \href{https://www.cdc.gov/nchs/nsfg/index.htm}{National Survey of Family Growth} (NSFG)
regularly collects fertility and other health information from a population-representative sample of adults in the
United States. Between 1973 and 2002, the NSFG was conducted periodically. Starting in 2002, the NSFG transitioned to
continuous data collection, releasing data in three-year waves (e.g., the 2013-2015, 2015-2017). The \code{nsfg()} function reads
the raw data from CDC's website, extracts and recodes selected variables useful for studying childfree adults and other family
statuses, then returns a single data frame.

\strong{Weights}

The \href{https://cran.r-project.org/package=survey}{\code{survey}} package can be used to incorporate sampling weights
and obtain population-representative estimates by wave. After using \code{nsfg()} to obtain data for a given wave (see example below), use
\code{dat <- svydesign(data = dat, ids = ~cluster, strata = ~stratum, weights = ~weight, nest = TRUE)} to incorporate information about
the survey design.

\strong{Known issues}
\itemize{
\item Starting in 2006, "hispanic" was a response option for race, however "hispanic" is not a racial category, but an ethnicity.
When a respondent chose this option, their actual race is unknown.
}
}
\examples{
\donttest{data <- nsfg(years = 2017)}
}
