% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/childesr.R
\name{get_participants}
\alias{get_participants}
\title{Get participants}
\usage{
get_participants(
  collection = NULL,
  corpus = NULL,
  target_child = NULL,
  role = NULL,
  role_exclude = NULL,
  age = NULL,
  sex = NULL,
  connection = NULL,
  db_version = "current",
  db_args = NULL
)
}
\arguments{
\item{collection}{A character vector of one or more names of collections}

\item{corpus}{A character vector of one or more names of corpora}

\item{target_child}{A character vector of one or more names of children}

\item{role}{A character vector of one or more roles to include}

\item{role_exclude}{A character vector of one or more roles to exclude}

\item{age}{A numeric vector of an single age value or a min age value and max
age value (inclusive) in months. For a single age value, participants are
returned for which that age is within their age range; for two ages,
participants are returned for whose age overlaps with the interval between
those two ages.}

\item{sex}{A character vector of values "male" and/or "female"}

\item{connection}{A connection to the CHILDES database}

\item{db_version}{String of the name of database version to use}

\item{db_args}{List with host, user, and password defined}
}
\value{
A `tbl` of Participant data, filtered down by supplied arguments. If
  `connection` is supplied, the result remains a remote query, otherwise it
  is retrieved into a local tibble.
}
\description{
Get participants
}
\examples{
\dontrun{
get_participants()
}
}
