% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mng01.R
\docType{data}
\name{mng01_main}
\alias{mng01_main}
\alias{mng01_pre}
\alias{mng01}
\title{\code{MNG01} Mean Plot Graph.}
\format{
An object of class \code{chevron_g} of length 1.
}
\usage{
mng01_main(
  adam_db,
  dataset = "adlb",
  x_var = "AVISIT",
  y_var = "AVAL",
  y_name = "PARAM",
  y_unit = NULL,
  arm_var = "ACTARM",
  center_fun = "mean",
  interval_fun = "mean_ci",
  jitter = 0.3,
  line_col = nestcolor::color_palette(),
  line_type = NULL,
  ggtheme = gg_theme_chevron(),
  table = c("n", center_fun, interval_fun),
  ...
)

mng01_pre(adam_db, dataset, x_var = "AVISIT", ...)

mng01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{x_var}{(\code{string}) the name of a column in the \code{dataset} to represent on the x-axis.}

\item{y_var}{(\code{string}) the name of the variable to be represented on the y-axis.}

\item{y_name}{(\code{string}) the variable name for \code{y}. Used for plot's subtitle.}

\item{y_unit}{(\code{string}) the name of the variable with the units of \code{y}. Used for plot's subtitle. if \code{NULL}, only
\code{y_name} is displayed as subtitle.}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{center_fun}{(\code{string}) the function to compute the estimate value.}

\item{interval_fun}{(\code{string}) the function defining the crossbar range. If \code{NULL}, no crossbar is displayed.}

\item{jitter}{(\code{numeric}) the width of spread for data points on the x-axis; a number from 0 (no \code{jitter}) to 1 (high
\code{jitter}), with a default of 0.3 (slight \code{jitter}).}

\item{line_col}{(\code{character}) describing the colors to use for the lines or a named \code{character} associating values of
\code{arm_var} with color names.}

\item{line_type}{(\code{character}) describing the line type to use for the lines or a named \code{character} associating
values of \code{arm_var} with line types.}

\item{ggtheme}{(\code{theme}) passed to \code{\link[tern:g_lineplot]{tern::g_lineplot()}}.}

\item{table}{(\code{character}) names of the statistics to be displayed in the table. If \code{NULL}, no table is displayed.}

\item{...}{passed to \code{\link[tern:g_lineplot]{tern::g_lineplot()}}.}
}
\value{
the main function returns a \code{list} of \code{ggplot} objects.

a list of \code{ggplot} objects.

the preprocessing function returns a \code{list} of \code{data.frame}.
}
\description{
Overview of a summary statistics across time and arm for a selected data set.
}
\details{
\itemize{
\item No overall value.
\item Preprocessing filters for \code{ANL01FL} in the selected data set.
}
}
\section{Functions}{
\itemize{
\item \code{mng01_main()}: Main TLG Function

\item \code{mng01_pre()}: Preprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain the table specified by \code{dataset} with the columns specified by \code{x_var}, \code{y_var},
\code{y_name}, \code{y_unit} and \code{arm_var}.
}
}
\examples{
col <- c(
  "A: Drug X" = "black",
  "B: Placebo" = "blue",
  "C: Combination" = "gray"
)

lt <- c(
  "A: Drug X" = "29",
  "B: Placebo" = "99",
  "C: Combination" = "solid"
)

run(
  mng01,
  syn_data,
  dataset = "adlb",
  x_var = c("AVISIT", "AVISITN"),
  line_col = col,
  line_type = lt
)
}
\seealso{
\code{\link[=gg_theme_chevron]{gg_theme_chevron()}}, \code{\link[tern:g_lineplot]{tern::g_lineplot()}}.
}
\keyword{datasets}
