% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chest_cox.R
\name{chest_cox}
\alias{chest_cox}
\title{Assessing confounding effects using Cox Proportional Hazards regression models}
\usage{
chest_cox(
  crude,
  xlist,
  data,
  var_lab = "Variables",
  est_lab = "HR (95\% CI)",
  change_lab = "Change, \%",
  digits = "\%.2f",
  digits_change = "\%.1f",
  na_omit = FALSE,
  hrzl_lines = gpar(col = "#444444"),
  text_size = 1,
  xlab_size = 1,
  xtick_size = 1,
  xlab = NULL,
  plus = "  + ",
  indicate = FALSE,
  ...
)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of characters with variable names of potential confounders.}

\item{data}{\emph{Data frame}.}

\item{var_lab}{\emph{Character} string for the column name of variables in the graph.}

\item{est_lab}{\emph{Character} string for the column name of effect estimates.}

\item{change_lab}{\emph{Character} string for the column name of "Changes".}

\item{digits}{Set the display format for number in the graph other than the \emph{"Change"} column. Default: "\%.2f"}

\item{digits_change}{Set the format for the \emph{"Change"} column. Default: "\%.1f"}

\item{na_omit}{Remove all missing values.}

\item{hrzl_lines}{A \emph{logic} to include or remove horizontal line.}

\item{text_size}{Set text size.}

\item{xlab_size}{Set \code{x} label size.}

\item{xtick_size}{Set \code{x} tick label size.}

\item{xlab}{Add \code{x} label.}

\item{plus}{Change the \code{+} sign before variable names.}

\item{indicate}{indicate the progress.}

\item{...}{Further optional arguments for forestplot.}
}
\value{
A table with effect estimates and their changes at all steps.
}
\description{
\code{'chest_cox'} is used to assess confounding effects
using Proportional Hazards Regression Model (\code{'coxph'} from \pkg{'survival'} package).
It presents the effect estimates (such as hazard ratios) for the association between exposure and outcome variables by adding other variables (potential confounders) to the model sequentially.
The order of variables to be added is based on the magnitudes of the changes in effect estimates.
}
\examples{

vlist <- c("Age", "Sex", "Married", "Cancer", "CVD", "Education", "Income")

chest_cox(crude = "Surv(t0, t1, Endpoint) ~ Diabetes", xlist = vlist, data = diab_df)

}
\seealso{
\pkg{'forestplot'}

\pkg{'survival'}
}
