% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_model_params.R
\name{MakeModelDefaults}
\alias{MakeModelDefaults}
\title{Model parameters for ModelTrain}
\usage{
MakeModelDefaults(n, p, classify, nfolds)
}
\arguments{
\item{n}{The number of observations in the data.}

\item{p}{The number of descriptors in the data.}

\item{classify}{A logical.  Will classification models be used? (is
the response binary?)
If false, regression models will be assumed.}

\item{nfolds}{The number of folds used for k-fold cross validation.}
}
\value{
A list whose elements are dataframes containing the
default parameter values for models implemented in
\code{\link{ModelTrain}}.
}
\description{
Makes a list containing the default parameters for all
models implemented in \code{\link{ModelTrain}}.
}
\details{
Sensible default values are selected for each
tunable model parameter, however users may set any parameter
manually by generating a list with this function and assigning
the parameters.

See \url{https://jrash.github.io/chemmodlab/} for more information about the
models available (including model default parameters).
}
\examples{
params <- MakeModelDefaults(n = nrow(USArrests),
 p = ncol(USArrests[, -1]), classify = TRUE, nfolds = 10)
params$Forest$mtry <- ncol(USArrests[, -1])-1
params

cml <- ModelTrain(USArrests, models = "RF", nsplits = 3,
 user.params = params)


}
\author{
Jeremy Ash
}
\seealso{
\code{\link{ModelTrain}}, \code{\link{chemmodlab}}
}

