% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{as_logical_index}
\alias{as_logical_index}
\title{Assure a full length logical index}
\usage{
as_logical_index(index, n)
}
\arguments{
\item{index}{A vector, typically a numeric row index of the data to
coerce to a logical index.}

\item{n}{Single numeric, the number of rows of the data use as a replicate
return length.}
}
\value{
A logical index of length n.
}
\description{
Suggests a alpha opacity to plot with as a function of the number of
observation.
}
\examples{
library(cheem)

## Coerce a numeric index to logical
as_logical_index(c(1, 4:10, 15), nrow(mtcars))

## Logical indexs are unchanged
as_logical_index(mtcars$mpg > 30, nrow(mtcars))
}
\seealso{
Other cheem utility: 
\code{\link{color_scale_of}()},
\code{\link{contains_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()},
\code{\link{sug_basis}()},
\code{\link{sug_manip_var}()}
}
\concept{cheem utility}
