% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{global_view}
\alias{global_view}
\title{Linked \code{plotly} display, global view of data and attribution space.}
\usage{
global_view(
  cheem_ls,
  primary_obs = NULL,
  comparison_obs = NULL,
  color = c("default", "residual", "log_maha.data", "cor_attr_proj.y"),
  height_px = 480,
  width_px = 1440,
  as_ggplot = FALSE
)
}
\arguments{
\item{cheem_ls}{A return from \code{cheem_ls()}, a list of data frames.}

\item{primary_obs}{The rownumber of the primary observation. Its local
attribution becomes the 1d projection basis, and the point it highlighted
as a dashed line. Defaults to NULL, no highlighting applied.}

\item{comparison_obs}{The rownumber of the comparison observation. Point
is highlighted as a dotted line. Defaults to NULL, no highlighting applied.}

\item{color}{The name of the column in cheem_ls$global_view_df to map to
color. Expects c("default", "residual", "log_maha.data", "cor_attr_proj.y").
Defaults to "default"; predicted_class for classification, dummy class
for regression.}

\item{height_px}{The height in pixels of the returned \code{plotly} plot.
Defaults to 480, does nothing when \code{as_ggplot} is TRUE.}

\item{width_px}{The width in pixels of the returned \code{plotly} plot.
Defaults to 1440, does nothing when \code{as_ggplot} is TRUE.}

\item{as_ggplot}{Logical, if TRUE returns the plots before being passed to
\code{plotly} functions.}
}
\value{
A \code{plotly} plot, an interactive html widget of the global view,
first two components of the basis of the data- and attribution- spaces.
}
\description{
from a cheem_ls() list, create a linked \code{plotly} of the global data-
and attribution- spaces. Typically consumed directly by shiny app.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## global_view()
ames_rf_chm <- cheem_ls(X, Y, ames_rf_shap, ames_rf_pred, clas,
                        label = "North Ames, RF, SHAP")
if(interactive()){
  cheem:::global_view_legwork(ames_rf_chm) ## most of the way there
  global_view(ames_rf_chm, as_ggplot = TRUE) ## early return of ggplot
  global_view(ames_rf_chm) ## uses ggplot facets \%>\% plotly

  ## Different color mappings, especially for regression
  global_view(ames_rf_chm, color = "residual")
  global_view(ames_rf_chm, color = "log_maha.data")
  global_view(ames_rf_chm, color = "cor_attr_proj.y")
}
## Also consumed by: ?run_app()
}
\seealso{
\code{\link[=run_app]{run_app()}}

Other cheem consumers: 
\code{\link{global_view_legwork}()},
\code{\link{radial_cheem_tour}()},
\code{\link{run_app}()}
}
\concept{cheem consumers}
