\name{PredationMatrixToLinks}
\alias{PredationMatrixToLinks}
\title{Predation matrix to trophic links}
\description{A function that converts a predation matrix to a 
\code{data.frame} with the columns `resource' and `consumer'.}

\usage{
PredationMatrixToLinks(pm)
}

\arguments{
  \item{pm}{a \code{matrix} or \code{data.frame} whose elements are either 0 
    or 1.}
}

\details{Returns a \code{data.frame} of trophic links contained within
\code{pm}. A 1 indicates a trophic link between a resource (row) and consumer 
(column). \code{pm} should have both row names and column names. The returned 
\code{data.frame} contains the columns `resource' and `consumer'.

If you have existing food-web data in predation-matrix form then this function 
can help to import your data in to Cheddar.
}

\value{A \code{data.frame}}

\author{Lawrence Hudson}

\seealso{\code{\link{Community}}, 
         \code{\link{PredationMatrix}}, 
         \code{\link{TLPS}}}

\examples{
data(TL84)

links <- PredationMatrixToLinks(PredationMatrix(TL84))
identical(links, TLPS(TL84))    # TRUE

# Create a Cheddar community from an existing square predation matrix
node <- c('Leaf', 'Caterpillar', 'Bluetit')
pm <- matrix( c(0, 1, 0,
                0, 0, 1,
                0, 0, 0), 
             ncol=3, byrow=TRUE, dimnames=list(node, node))

community1 <- Community(nodes=data.frame(node=node),
                        trophic.links=PredationMatrixToLinks(pm),
                        properties=list(title='Test community'))
TLPS(community1)

# The same set of trophic links could be represented by a non-square predation 
# matrix
pm <- matrix( c(1, 0,
                0, 1), 
             ncol=2, byrow=TRUE, 
             dimnames=list(node[1:2], node[2:3]))

community2 <- Community(nodes=data.frame(node=node),
                        trophic.links=PredationMatrixToLinks(pm),
                        properties=list(title='Test community'))
TLPS(community2)

all.equal(community1, community2)    # TRUE
}

\keyword{utilities}

