% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key.R
\name{check_key}
\alias{check_key}
\title{Check Key}
\usage{
check_key(x, key = names(x), x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The data to check.}

\item{key}{A character vector of the column names representing the key.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks that columns in a data frame represent a unique key.
By default all the columns are checked.
}
\examples{
data <- data.frame(x = 1:1, y = 1:2)
check_key(data, "x", error = FALSE)
check_key(data, c("y", "x"), error = FALSE)
}
\seealso{
\code{\link{check_data}}
}
