% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkpoint_remove.R
\name{checkpointRemove}
\alias{checkpointRemove}
\title{Remove checkpoint archive from disk.}
\usage{
checkpointRemove(snapshotDate, checkpointLocation = "~/",
  allSinceSnapshot = FALSE, allUntilSnapshot = FALSE,
  notUsedSince = FALSE)
}
\arguments{
\item{snapshotDate}{Date of snapshot to use in \code{YYYY-MM-DD} format, e.g. \code{"2014-09-17"}.  Specify a date on or after \code{"2014-09-17"}.  MRAN takes one snapshot per day. To list all valid snapshot dates on MRAN use \code{\link[=getValidSnapshots]{getValidSnapshots()}}}

\item{checkpointLocation}{File path where the checkpoint library is stored.  Default is \code{"~/"}, i.e. the user's home directory. A use case for changing this is to create a checkpoint library on a portable drive (e.g. USB drive).}

\item{allSinceSnapshot}{If \code{TRUE}, removes all snapshot archives since the \code{snapshotDate}}

\item{allUntilSnapshot}{If \code{TRUE}, removes all snapshot archives before the \code{snapshotDate}}

\item{notUsedSince}{If \code{TRUE}, removes all snapshot archives that have not been accessed since the \code{snapshotDate}. See \code{\link[=getAccessDate]{getAccessDate()}}}
}
\description{
This function enables you to delete a snapshot archive folder from disk, thus releasing storage space. If you supply a single \code{snapshotDate}, then only this archive will be removed. You also have the option to remove a series of snapshots, including all snapshots before a given date, or all snapshots that have not been accessed since a given date.
}
\examples{
checkpointArchives()
\dontrun{
checkpointRemove("2016-10-01")
}

}
\seealso{
\code{\link[=getAccessDate]{getAccessDate()}}

Other checkpoint functions: \code{\link{checkpointArchives}},
  \code{\link{checkpoint}}, \code{\link{getAccessDate}},
  \code{\link{getValidSnapshots}}, \code{\link{mranUrl}},
  \code{\link{setSnapshot}}, \code{\link{unCheckpoint}}
}
