% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkpoint-package.R
\docType{package}
\name{checkpoint-package}
\alias{checkpoint-package}
\title{Install packages from snapshots on the checkpoint server for reproducibility}
\description{
The goal of checkpoint is to solve the problem of package reproducibility in R. Specifically, checkpoint allows you to install packages as they existed on CRAN on a specific snapshot date as if you had a CRAN time machine.
}
\details{
To achieve reproducibility, the \code{\link[=checkpoint]{checkpoint()}} function installs the packages required or called by your project and scripts to a local library exactly as they existed at the specified point in time. Only those packages are available tot your project, thereby avoiding any package updates that came later and may have altered your results. In this way, anyone using the checkpoint \code{\link[=checkpoint]{checkpoint()}} function can ensure the reproducibility of your scripts or projects at any time.

To create the snapshot archives, once a day (at midnight UTC) we refresh the Austria CRAN mirror, on the checkpoint server (https://mran.microsoft.com/).  Immediately after completion of the `rsync`` mirror process, we take a snapshot, thus creating the archive.  Snapshot archives exist starting from 2014-09-17.

\code{checkpoint} exposes functions for:
\itemize{
\item Creating and using snapshots:
\itemize{
\item \code{\link[=checkpoint]{checkpoint()}}: Configures R session to use packages as they existed on CRAN at time of snapshot.
\item \code{\link[=setSnapshot]{setSnapshot()}}: Set default CRAN repository to MRAN snapshot date.
\item \code{\link[=getValidSnapshots]{getValidSnapshots()}}: Read list of available snapshot dates from MRAN.
}
\item Managing local archives:
\itemize{
\item \code{\link[=checkpointArchives]{checkpointArchives()}}: List checkpoint archives on disk.
\item \code{\link[=checkpointRemove]{checkpointRemove()}}: Remove checkpoint archive from disk.
\item \code{\link[=getAccessDate]{getAccessDate()}}: Returns the date the snapshot was last accessed.
}
\item Other:
\itemize{
\item \code{\link[=unCheckpoint]{unCheckpoint()}}: (Experimental) Reset the \code{.libPath} to the user library
}
}
}
\keyword{package}
