context("checkString")

test_that("checkString", {
  expect_succ_all(String, "a")
  expect_succ_all(String, "")
  expect_fail_all(String, "", min.chars = 1)
  expect_fail_all(String, 1L)
  expect_succ_all(String, NA_character_, na.ok = TRUE, min.chars = 99)
  expect_succ_all(String, "xxxfooxxx", pattern = "foo")
  expect_succ_all(String, "xxxfooxxx", fixed = "foo")
  expect_fail_all(String, "xxxfooxxx", pattern = "bar")
  expect_fail_all(String, "xxxfooxxx", fixed = "bar")
  expect_succ_all(String, "xxxfooxxx", pattern = "FOO", ignore.case = TRUE)
  expect_fail_all(String, "xxxfooxxx", fixed = "FOO", ignore.case = FALSE)

  expect_false(testString(character(0)))
  expect_false(testString(NULL))
  expect_true(testString(""))
  expect_true(testString("foo"))
  expect_true(testString(NA, na.ok = TRUE))
  expect_false(testString(NA_character_))
  expect_true(testString(NA_character_, na.ok = TRUE))
  expect_true(testString(NA, na.ok = TRUE))
  expect_true(testString("a", min.chars = 1))
  expect_false(testString("", min.chars = 1))
  expect_true(testString(NA_character_, min.chars = 1, na.ok = TRUE))
  expect_true(testString(NA_real_, min.chars = 1, na.ok = TRUE))
  expect_error(assertString(1))

  expect_true(testString("a", n.chars = 1))
  expect_false(testString("", n.chars = 1))
  expect_true(testString("a", max.chars = 1))
  expect_false(testString("ab", max.chars = 1))
})
